/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;

public interface ActiveMQServerPlugin {
    default public void afterCreateConnection(RemotingConnection connection) throws ActiveMQException {
    }

    default public void afterDestroyConnection(RemotingConnection connection) throws ActiveMQException {
    }

    default public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
    }

    default public void afterCreateSession(ServerSession session) throws ActiveMQException {
    }

    default public void beforeCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
    }

    default public void afterCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
    }

    default public void beforeSessionMetadataAdded(ServerSession session, String key, String data) throws ActiveMQException {
    }

    default public void afterSessionMetadataAdded(ServerSession session, String key, String data) throws ActiveMQException {
    }

    @Deprecated
    default public void beforeCreateConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) throws ActiveMQException {
    }

    default public void beforeCreateConsumer(long consumerID, QueueBinding queueBinding, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) throws ActiveMQException {
        this.beforeCreateConsumer(consumerID, queueBinding.getQueue().getName(), filterString, browseOnly, supportLargeMessage);
    }

    default public void afterCreateConsumer(ServerConsumer consumer) throws ActiveMQException {
    }

    default public void beforeCloseConsumer(ServerConsumer consumer, boolean failed) throws ActiveMQException {
    }

    default public void afterCloseConsumer(ServerConsumer consumer, boolean failed) throws ActiveMQException {
    }

    default public void beforeCreateQueue(QueueConfig queueConfig) throws ActiveMQException {
    }

    default public void afterCreateQueue(Queue queue) throws ActiveMQException {
    }

    default public void beforeDestroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws ActiveMQException {
    }

    default public void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws ActiveMQException {
    }

    default public void beforeSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
        this.beforeSend(tx, message, direct, noAutoCreateQueue);
    }

    default public void afterSend(ServerSession session, Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) throws ActiveMQException {
        this.afterSend(tx, message, direct, noAutoCreateQueue, result);
    }

    @Deprecated
    default public void beforeSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) throws ActiveMQException {
    }

    @Deprecated
    default public void afterSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) throws ActiveMQException {
    }

    default public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) throws ActiveMQException {
    }

    default public void afterMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, RoutingStatus result) throws ActiveMQException {
    }

    default public void beforeDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        this.beforeDeliver(reference);
    }

    default public void afterDeliver(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        this.afterDeliver(reference);
    }

    @Deprecated
    default public void beforeDeliver(MessageReference reference) throws ActiveMQException {
    }

    @Deprecated
    default public void afterDeliver(MessageReference reference) throws ActiveMQException {
    }

    default public void messageExpired(MessageReference message, SimpleString messageExpiryAddress) throws ActiveMQException {
    }

    default public void messageAcknowledged(MessageReference ref, AckReason reason) throws ActiveMQException {
    }

    default public void beforeDeployBridge(BridgeConfiguration config) throws ActiveMQException {
    }

    default public void afterDeployBridge(Bridge bridge) throws ActiveMQException {
    }

    default public void criticalFailure(CriticalComponent components) throws ActiveMQException {
    }
}

