/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.macro.snippet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.snippet.SnippetReader;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.codehaus.plexus.util.StringUtils;

public class SnippetMacro
extends AbstractMacro {
    private static Map<String, String> cache = new HashMap<String, String>();
    private static final int HOUR = 60;
    private long timeout = 3600000L;
    private static Map<String, Long> timeCached = new HashMap<String, Long>();
    private boolean debug = false;

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        StringBuffer snippet;
        URL url;
        String id = (String)request.getParameter("id");
        String urlParam = (String)request.getParameter("url");
        String fileParam = (String)request.getParameter("file");
        boolean verbatim = true;
        String verbatimParam = (String)request.getParameter("verbatim");
        if (verbatimParam != null && !"".equals(verbatimParam)) {
            verbatim = Boolean.valueOf(verbatimParam);
        }
        if (!StringUtils.isEmpty((String)urlParam)) {
            try {
                url = new URL(urlParam);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(urlParam + " is a malformed URL");
            }
        } else if (!StringUtils.isEmpty((String)fileParam)) {
            File f = new File(fileParam);
            if (!f.isAbsolute()) {
                f = new File(request.getBasedir(), fileParam);
            }
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(fileParam + " is a malformed URL");
            }
        } else {
            throw new IllegalArgumentException("Either the 'url' or the 'file' param has to be given.");
        }
        try {
            snippet = this.getSnippet(url, id);
        }
        catch (IOException e) {
            throw new MacroExecutionException("Error reading snippet", e);
        }
        if (verbatim) {
            sink.verbatim(SinkEventAttributeSet.BOXED);
            sink.text(snippet.toString());
            sink.verbatim_();
        } else {
            sink.rawText(snippet.toString());
        }
    }

    private StringBuffer getSnippet(URL url, String id) throws IOException {
        StringBuffer result;
        String cachedSnippet = this.getCachedSnippet(url, id);
        if (cachedSnippet != null) {
            result = new StringBuffer(cachedSnippet);
            if (this.debug) {
                result.append("(Served from cache)");
            }
        } else {
            result = new SnippetReader(url).readSnippet(id);
            this.cacheSnippet(url, id, result.toString());
            if (this.debug) {
                result.append("(Fetched from url, cache content ").append(cache).append(")");
            }
        }
        return result;
    }

    private String getCachedSnippet(URL url, String id) {
        if (this.isCacheTimedout(url, id)) {
            this.removeFromCache(url, id);
        }
        return cache.get(this.globalSnippetId(url, id));
    }

    boolean isCacheTimedout(URL url, String id) {
        return this.timeInCache(url, id) >= this.timeout;
    }

    long timeInCache(URL url, String id) {
        return System.currentTimeMillis() - this.getTimeCached(url, id);
    }

    long getTimeCached(URL url, String id) {
        String globalId = this.globalSnippetId(url, id);
        return timeCached.containsKey(globalId) ? timeCached.get(globalId) : 0L;
    }

    private void removeFromCache(URL url, String id) {
        String globalId = this.globalSnippetId(url, id);
        timeCached.remove(globalId);
        cache.remove(globalId);
    }

    private String globalSnippetId(URL url, String id) {
        if (StringUtils.isEmpty((String)id)) {
            return url.toString();
        }
        return url + " " + id;
    }

    public void cacheSnippet(URL url, String id, String content) {
        cache.put(this.globalSnippetId(url, id), content);
        timeCached.put(this.globalSnippetId(url, id), new Long(System.currentTimeMillis()));
    }

    public void setCacheTimeout(int time) {
        this.timeout = time;
    }
}

