/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.model.TaskEvent;

public class RuntimeDataServiceImpl
implements RuntimeDataService,
DeploymentEventListener {
    private static final int MAX_CACHE_ENTRIES = Integer.parseInt(System.getProperty("org.jbpm.service.cache.size", "100"));
    protected Set<ProcessDefinition> availableProcesses = new HashSet<ProcessDefinition>();
    protected Map<String, List<String>> deploymentsRoles = new HashMap<String, List<String>>();
    protected Map<String, List<String>> userDeploymentIdsCache = new LinkedHashMap<String, List<String>>(){
        private static final long serialVersionUID = -2324394641773215253L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<String>> eldest) {
            return this.size() > MAX_CACHE_ENTRIES;
        }
    };
    private TransactionalCommandService commandService;
    private IdentityProvider identityProvider;
    protected TaskService taskService;
    protected TaskAuditService taskAuditService;

    public RuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/Servicesorm.xml");
        QueryManager.get().addNamedQueries("META-INF/TaskAuditorm.xml");
        QueryManager.get().addNamedQueries("META-INF/Taskorm.xml");
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setTaskAuditService(TaskAuditService taskAuditService) {
        this.taskAuditService = taskAuditService;
    }

    public void onDeploy(DeploymentEvent event) {
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        List<Object> roles = null;
        for (DeployedAsset asset : assets) {
            if (!(asset instanceof ProcessAssetDesc)) continue;
            this.availableProcesses.add((ProcessAssetDesc)asset);
            if (roles != null) continue;
            roles = ((ProcessAssetDesc)asset).getRoles();
        }
        if (roles == null) {
            roles = Collections.emptyList();
        }
        this.deploymentsRoles.put(event.getDeploymentId(), roles);
        this.userDeploymentIdsCache.clear();
    }

    public void onUnDeploy(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        this.availableProcesses.removeAll(outputCollection);
        this.deploymentsRoles.remove(event.getDeploymentId());
        this.userDeploymentIdsCache.clear();
    }

    public void onActivate(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        for (ProcessAssetDesc process : outputCollection) {
            process.setActive(true);
        }
    }

    public void onDeactivate(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        for (ProcessAssetDesc process : outputCollection) {
            process.setActive(false);
        }
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected List<String> getDeploymentsForUser() {
        String identityName = null;
        List roles = null;
        try {
            identityName = this.identityProvider.getName();
            roles = this.identityProvider.getRoles();
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        List<String> usersDeploymentIds = this.userDeploymentIdsCache.get(identityName);
        if (usersDeploymentIds != null) {
            return usersDeploymentIds;
        }
        usersDeploymentIds = new ArrayList<String>();
        this.userDeploymentIdsCache.put(identityName, usersDeploymentIds);
        boolean isSecured = false;
        for (Map.Entry<String, List<String>> entry : this.deploymentsRoles.entrySet()) {
            if (entry.getValue().isEmpty() || CollectionUtils.containsAny((Collection)roles, (Collection)entry.getValue())) {
                usersDeploymentIds.add(entry.getKey());
            }
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            isSecured = true;
        }
        if (isSecured && usersDeploymentIds.isEmpty()) {
            usersDeploymentIds.add("deployments-are-secured");
        }
        return usersDeploymentIds;
    }

    protected void applyDeploymentFilter(Map<String, Object> params) {
        List<String> deploymentIdForUser = this.getDeploymentsForUser();
        if (deploymentIdForUser != null && !deploymentIdForUser.isEmpty()) {
            params.put("filter", " log.externalId in (:deployments) ");
            params.put("deployments", deploymentIdForUser);
        }
    }

    protected <T> Collection<T> applyPaginition(List<T> input, QueryContext queryContext) {
        if (queryContext != null) {
            int start = queryContext.getOffset();
            int end = start + queryContext.getCount();
            if (input.size() < start) {
                return new ArrayList();
            }
            if (input.size() >= end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, end)));
            }
            if (input.size() < end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, input.size())));
            }
        }
        return Collections.unmodifiableCollection(input);
    }

    protected void applySorting(List<ProcessDefinition> input, final QueryContext queryContext) {
        if (queryContext != null && queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
            Collections.sort(input, new Comparator<ProcessDefinition>(){

                @Override
                public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                    if ("ProcessName".equals(queryContext.getOrderBy())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if ("ProcessVersion".equals(queryContext.getOrderBy())) {
                        return o1.getVersion().compareTo(o2.getVersion());
                    }
                    if ("Project".equals(queryContext.getOrderBy())) {
                        return o1.getDeploymentId().compareTo(o2.getDeploymentId());
                    }
                    return 0;
                }
            });
            if (!queryContext.isAscending().booleanValue()) {
                Collections.reverse(input);
            }
        }
    }

    public Collection<ProcessDefinition> getProcessesByDeploymentId(String deploymentId, QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(deploymentId, this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    public ProcessDefinition getProcessesByDeploymentIdProcessId(String deploymentId, String processId) {
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdProcessIdPredicate(deploymentId, processId, this.identityProvider.getRoles(), true), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessDefinition)outputCollection.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcessesByFilter(String filter, QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new RegExPredicate("(?i)^.*" + filter + ".*$", this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    @Deprecated
    public ProcessDefinition getProcessById(String processId) {
        Collection<ProcessDefinition> definitions = this.getProcessesById(processId);
        if (!definitions.isEmpty()) {
            return definitions.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcessesById(String processId) {
        HashSet<ProcessDefinition> outputCollection = new HashSet<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByProcessIdPredicate(processId, this.identityProvider.getRoles()), outputCollection);
        return outputCollection;
    }

    public Collection<ProcessDefinition> getProcesses(QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new SecurePredicate(this.identityProvider.getRoles(), false), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    public Collection<String> getProcessIds(String deploymentId, QueryContext queryContext) {
        ArrayList<String> processIds = new ArrayList<String>(this.availableProcesses.size());
        if (deploymentId == null || deploymentId.isEmpty()) {
            return processIds;
        }
        for (ProcessDefinition procAssetDesc : this.availableProcesses) {
            if (!((ProcessAssetDesc)procAssetDesc).getDeploymentId().equals(deploymentId) || !((ProcessAssetDesc)procAssetDesc).isActive()) continue;
            processIds.add(procAssetDesc.getId());
        }
        return this.applyPaginition(processIds, queryContext);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstances(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstances", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("externalId", deploymentId);
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByDeploymentId", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processDefId", processDefId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessDefinition", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processDefId);
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public org.jbpm.services.api.model.ProcessInstanceDesc getProcessInstanceById(long processId) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("processId", Long.valueOf(processId));
        params.put("maxResults", Integer.valueOf(1));
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceById", params));
        if (!processInstances.isEmpty()) {
            org.jbpm.services.api.model.ProcessInstanceDesc desc = (org.jbpm.services.api.model.ProcessInstanceDesc)processInstances.iterator().next();
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.add(Status.Ready.name());
            statuses.add(Status.Reserved.name());
            statuses.add(Status.InProgress.name());
            params = new HashMap();
            params.put("processInstanceId", desc.getId());
            params.put("statuses", statuses);
            List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstancesByProcessInstanceId", params));
            ((ProcessInstanceDesc)desc).setActiveTasks(tasks);
            return desc;
        }
        return null;
    }

    public org.jbpm.services.api.model.ProcessInstanceDesc getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm());
        params.put("maxResults", 1);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceByCorrelationKey", params));
        if (!processInstances.isEmpty()) {
            org.jbpm.services.api.model.ProcessInstanceDesc desc = (org.jbpm.services.api.model.ProcessInstanceDesc)processInstances.iterator().next();
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.add(Status.Ready.name());
            statuses.add(Status.Reserved.name());
            statuses.add(Status.InProgress.name());
            params = new HashMap();
            params.put("processInstanceId", desc.getId());
            params.put("statuses", statuses);
            List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstancesByProcessInstanceId", params));
            ((ProcessInstanceDesc)desc).setActiveTasks(tasks);
            return desc;
        }
        return null;
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByCorrelationKey(CorrelationKey correlationKey, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm() + "%");
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByCorrelationKey", params));
        return processInstances;
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByVariable(String variableName, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (states == null || states.isEmpty()) {
            states = new ArrayList<Integer>();
            states.add(1);
        }
        params.put("states", states);
        params.put("variable", variableName);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByVariableName", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (states == null || states.isEmpty()) {
            states = new ArrayList<Integer>();
            states.add(1);
        }
        params.put("states", states);
        params.put("variable", variableName);
        params.put("variableValue", variableValue);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByVariableNameAndValue", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryActive(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, false, queryContext);
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryCompleted(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, true, queryContext);
    }

    protected Collection<NodeInstanceDesc> getProcessInstanceHistory(long processId, boolean completed, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = Collections.emptyList();
        nodeInstances = completed ? (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceCompletedNodes", params)) : (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceActiveNodes", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(long processId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistory", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistoryByType(long processId, RuntimeDataService.EntryType type, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("type", type.getValue());
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistoryByType", params));
        return nodeInstances;
    }

    public NodeInstanceDesc getNodeInstanceForWorkItem(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getNodeInstanceForWorkItem", params));
        if (!nodeInstances.isEmpty()) {
            return (NodeInstanceDesc)nodeInstances.iterator().next();
        }
        return null;
    }

    public Collection<VariableDesc> getVariablesCurrentState(long processInstanceId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariablesCurrentState", params));
        return variablesState;
    }

    public Collection<VariableDesc> getVariableHistory(long processInstanceId, String variableId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("variableId", variableId);
        this.applyQueryContext(params, queryContext);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariableHistory", params));
        return variablesState;
    }

    public UserTaskInstanceDesc getTaskByWorkItemId(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceByWorkItemId", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public UserTaskInstanceDesc getTaskById(Long taskId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("taskId", taskId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceById", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, QueryFilter filter) {
        ArrayList<Status> allActiveStatus = new ArrayList<Status>();
        allActiveStatus.add(Status.Created);
        allActiveStatus.add(Status.Ready);
        allActiveStatus.add(Status.Reserved);
        allActiveStatus.add(Status.InProgress);
        allActiveStatus.add(Status.Suspended);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", allActiveStatus);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksAssignedAsBusinessAdministratorByStatus", params));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, groupIds, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, groupIds, status, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, status, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date from, QueryFilter filter) {
        List taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, status, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksAssignedAsPotentialOwner(userId, null, status, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> strStatuses, Date from, QueryFilter filter) {
        List taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksOwned(userId, null, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = ((InternalTaskService)this.taskService).getTasksOwned(userId, null, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwned(String userId, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksOwned(userId, null, filter);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksOwned(userId, status, filter);
    }

    public List<Long> getTasksByProcessInstanceId(Long processInstanceId) {
        return this.taskService.getTasksByProcessInstanceId(processInstanceId.longValue());
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(Long processInstanceId, List<Status> status, QueryFilter filter) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Status>();
            status.add(Status.Created);
            status.add(Status.Ready);
            status.add(Status.Reserved);
            status.add(Status.InProgress);
            status.add(Status.Suspended);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("status", status);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksByStatusByProcessId", params));
    }

    public List<AuditTask> getAllAuditTask(String userId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", userId);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllAuditTasksByUser", params));
        return auditTasks;
    }

    public List<AuditTask> getAllAuditTaskByStatus(String userId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", userId);
        params.put("statuses", filter.getParams().get("statuses"));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllAuditTasksByStatus", params));
        return auditTasks;
    }

    public List<AuditTask> getAllGroupAuditTask(String userId, QueryFilter filter) {
        return this.taskAuditService.getAllGroupAuditTasksByUser(userId, filter);
    }

    public List<AuditTask> getAllAdminAuditTask(String userId, QueryFilter filter) {
        return this.taskAuditService.getAllAdminAuditTasksByUser(userId, filter);
    }

    public List<TaskEvent> getTaskEvents(long taskId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List taskEvents = (List)this.commandService.execute((Command)new QueryNameCommand("getAllTasksEvents", params));
        return taskEvents;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministratorByStatus(String userId, List<Status> statuses, QueryFilter filter) {
        return ((InternalTaskService)this.taskService).getTasksAssignedAsBusinessAdministratorByStatus(userId, filter.getLanguage(), statuses);
    }

    protected void applyQueryFilter(Map<String, Object> params, QueryFilter queryFilter) {
        if (queryFilter != null) {
            this.applyQueryContext(params, (QueryContext)queryFilter);
            if (queryFilter.getFilterParams() != null && !queryFilter.getFilterParams().isEmpty()) {
                params.put("filter", queryFilter.getFilterParams());
                for (String key : queryFilter.getParams().keySet()) {
                    params.put(key, queryFilter.getParams().get(key));
                }
            }
        }
    }

    private class ActiveOnlyPredicate
    implements Predicate {
        private ActiveOnlyPredicate() {
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).isActive();
        }
    }

    private class UnsecureByDeploymentIdPredicate
    implements Predicate {
        private String deploymentId;

        private UnsecureByDeploymentIdPredicate(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).getDeploymentId().equals(this.deploymentId);
        }
    }

    private class SecurePredicate
    extends ActiveOnlyPredicate {
        private List<String> roles;
        private boolean skipActivCheck;

        private SecurePredicate(List<String> roles, boolean skipActivCheck) {
            this.roles = roles;
            this.skipActivCheck = skipActivCheck;
        }

        @Override
        public boolean evaluate(Object object) {
            boolean isActive;
            if (!this.skipActivCheck && !(isActive = super.evaluate(object))) {
                return false;
            }
            ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
            if (this.roles == null || this.roles.isEmpty() || pDesc.getRoles() == null || pDesc.getRoles().isEmpty()) {
                return true;
            }
            return CollectionUtils.containsAny(this.roles, pDesc.getRoles());
        }
    }

    private class ByDeploymentIdProcessIdPredicate
    extends SecurePredicate {
        private String processId;
        private String depoymentId;

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles) {
            super(roles, false);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles, boolean skipActiveCheck) {
            super(roles, skipActiveCheck);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId) && pDesc.getDeploymentId().equals(this.depoymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByProcessIdPredicate
    extends SecurePredicate {
        private String processId;

        private ByProcessIdPredicate(String processId, List<String> roles) {
            super(roles, false);
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByDeploymentIdPredicate
    extends SecurePredicate {
        private String deploymentId;

        private ByDeploymentIdPredicate(String deploymentId, List<String> roles) {
            super(roles, false);
            this.deploymentId = deploymentId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getDeploymentId().equals(this.deploymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RegExPredicate
    extends SecurePredicate {
        private String pattern;

        private RegExPredicate(String pattern, List<String> roles) {
            super(roles, false);
            this.pattern = pattern;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().matches(this.pattern) || pDesc.getName().matches(this.pattern)) {
                    return true;
                }
            }
            return false;
        }
    }
}

