/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.io.Serializable;
import java.util.function.Function;
import org.jooq.Converters;

public interface Converter<T, U>
extends Serializable {
    public U from(T var1);

    public T to(U var1);

    public Class<T> fromType();

    public Class<U> toType();

    default public Converter<U, T> inverse() {
        return Converters.inverse(this);
    }

    default public <X> Converter<T, X> andThen(Converter<? super U, X> converter) {
        return Converters.of(this, converter);
    }

    public static <T, U> Converter<T, U> of(final Class<T> fromType, final Class<U> toType, final Function<? super T, ? extends U> from, final Function<? super U, ? extends T> to) {
        return new Converter<T, U>(){
            private static final long serialVersionUID = 8782437631959970693L;

            @Override
            public final U from(T t) {
                return from.apply(t);
            }

            @Override
            public final T to(U u) {
                return to.apply(u);
            }

            @Override
            public final Class<T> fromType() {
                return fromType;
            }

            @Override
            public final Class<U> toType() {
                return toType;
            }
        };
    }

    public static <T, U> Converter<T, U> ofNullable(Class<T> fromType, Class<U> toType, Function<? super T, ? extends U> from, Function<? super U, ? extends T> to) {
        return Converter.of(fromType, toType, t -> t == null ? null : from.apply(t), u -> u == null ? null : to.apply((Object)u));
    }
}

