/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.buffer.Buffer;
import org.springframework.boot.actuate.metrics.buffer.Buffers;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.reader.PrefixMetricReader;
import org.springframework.lang.UsesJava8;

@UsesJava8
public class BufferMetricReader
implements MetricReader,
PrefixMetricReader {
    private static final Predicate<String> ALL = Pattern.compile(".*").asPredicate();
    private final CounterBuffers counterBuffers;
    private final GaugeBuffers gaugeBuffers;

    public BufferMetricReader(CounterBuffers counterBuffers, GaugeBuffers gaugeBuffers) {
        this.counterBuffers = counterBuffers;
        this.gaugeBuffers = gaugeBuffers;
    }

    @Override
    public Metric<?> findOne(String name) {
        Object buffer = this.counterBuffers.find(name);
        if (buffer == null) {
            buffer = this.gaugeBuffers.find(name);
        }
        return buffer == null ? null : this.asMetric(name, (Buffer)buffer);
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        return this.findAll(ALL);
    }

    @Override
    public Iterable<Metric<?>> findAll(String prefix) {
        return this.findAll(Pattern.compile(prefix + ".*").asPredicate());
    }

    @Override
    public long count() {
        return this.counterBuffers.count() + this.gaugeBuffers.count();
    }

    private Iterable<Metric<?>> findAll(Predicate<String> predicate) {
        ArrayList metrics = new ArrayList();
        this.collectMetrics(this.gaugeBuffers, predicate, metrics);
        this.collectMetrics(this.counterBuffers, predicate, metrics);
        return metrics;
    }

    private <T extends Number, B extends Buffer<T>> void collectMetrics(Buffers<B> buffers, Predicate<String> predicate, final List<Metric<?>> metrics) {
        buffers.forEach(predicate, new BiConsumer<String, B>(){

            @Override
            public void accept(String name, B value) {
                metrics.add(BufferMetricReader.this.asMetric(name, value));
            }
        });
    }

    private <T extends Number> Metric<T> asMetric(String name, Buffer<T> buffer) {
        return new Metric<T>(name, buffer.getValue(), new Date(buffer.getTimestamp()));
    }
}

