/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.geo.format.DistanceFormatter;
import org.springframework.data.geo.format.PointFormatter;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.ProxyingHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class SpringDataWebConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private ApplicationContext context;
    @Autowired
    @Qualifier(value="mvcConversionService")
    ObjectFactory<ConversionService> conversionService;

    @Bean
    public PageableHandlerMethodArgumentResolver pageableResolver() {
        return new PageableHandlerMethodArgumentResolver(this.sortResolver());
    }

    @Bean
    public SortHandlerMethodArgumentResolver sortResolver() {
        return new SortHandlerMethodArgumentResolver();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addFormatter((Formatter)DistanceFormatter.INSTANCE);
        registry.addFormatter((Formatter)PointFormatter.INSTANCE);
        if (!(registry instanceof FormattingConversionService)) {
            return;
        }
        FormattingConversionService conversionService = (FormattingConversionService)registry;
        DomainClassConverter<FormattingConversionService> converter = new DomainClassConverter<FormattingConversionService>(conversionService);
        converter.setApplicationContext(this.context);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.sortResolver());
        argumentResolvers.add(this.pageableResolver());
        ProxyingHandlerMethodArgumentResolver resolver = new ProxyingHandlerMethodArgumentResolver((ConversionService)this.conversionService.getObject());
        resolver.setBeanFactory((BeanFactory)this.context);
        resolver.setResourceLoader((ResourceLoader)this.context);
        argumentResolvers.add((HandlerMethodArgumentResolver)resolver);
    }
}

