/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseBucket;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.CouchbaseExceptionTranslator;

public class CouchbaseBucketFactoryBean
extends AbstractFactoryBean<Bucket>
implements PersistenceExceptionTranslator {
    private final Cluster cluster;
    private final String bucketName;
    private final String bucketPassword;
    private final PersistenceExceptionTranslator exceptionTranslator = new CouchbaseExceptionTranslator();

    public CouchbaseBucketFactoryBean(Cluster cluster) {
        this(cluster, null, null);
    }

    public CouchbaseBucketFactoryBean(Cluster cluster, String bucketName) {
        this(cluster, bucketName, null);
    }

    public CouchbaseBucketFactoryBean(Cluster cluster, String bucketName, String bucketPassword) {
        this.cluster = cluster;
        this.bucketName = bucketName;
        this.bucketPassword = bucketPassword;
    }

    public Class<?> getObjectType() {
        return CouchbaseBucket.class;
    }

    protected Bucket createInstance() throws Exception {
        if (this.bucketName == null) {
            return this.cluster.openBucket();
        }
        if (this.bucketPassword == null) {
            return this.cluster.openBucket(this.bucketName);
        }
        return this.cluster.openBucket(this.bucketName, this.bucketPassword);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }
}

