/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.path.DefaultLimitPath;
import com.couchbase.client.java.query.dsl.path.DefaultOrderByPath;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.query.AbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringN1qlBasedQuery
extends AbstractN1qlBasedQuery {
    private final SpelExpressionParser parser;
    private final EvaluationContextProvider evaluationContextProvider;
    private final StringBasedN1qlQueryParser queryParser;

    protected String getTypeField() {
        return this.getCouchbaseOperations().getConverter().getTypeKey();
    }

    protected Class<?> getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType();
    }

    public StringN1qlBasedQuery(String statement, CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations, SpelExpressionParser spelParser, EvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, couchbaseOperations);
        this.queryParser = new StringBasedN1qlQueryParser(statement, queryMethod, this.getCouchbaseOperations().getCouchbaseBucket().name(), this.getCouchbaseOperations().getConverter(), this.getTypeField(), this.getTypeValue());
        this.parser = spelParser;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.queryParser.getPlaceholderValues(accessor);
    }

    @Override
    public Statement getStatement(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        Pageable pageable;
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        String parsedStatement = this.queryParser.doParse(this.parser, evaluationContext, false);
        String orderByPart = "";
        String limitByPart = "";
        Sort sort = accessor.getSort();
        if (sort.isSorted()) {
            com.couchbase.client.java.query.dsl.Sort[] cbSorts = N1qlUtils.createSort(sort, this.getCouchbaseOperations().getConverter());
            orderByPart = " " + new DefaultOrderByPath(null).orderBy(cbSorts).toString();
        }
        if (this.queryMethod.isPageQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            limitByPart = " " + new DefaultLimitPath(null).limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset())).toString();
        } else if (this.queryMethod.isSliceQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            limitByPart = " " + new DefaultLimitPath(null).limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset())).toString();
        }
        return N1qlQuery.simple((String)(parsedStatement + orderByPart + limitByPart)).statement();
    }

    @Override
    protected Statement getCount(ParameterAccessor accessor, Object[] runtimeParameters) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        String parsedStatement = this.queryParser.doParse(this.parser, evaluationContext, true);
        return N1qlQuery.simple((String)parsedStatement).statement();
    }

    @Override
    protected boolean useGeneratedCountQuery() {
        return this.queryParser.useGeneratedCountQuery();
    }
}

