/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.util.TypeInformation;

public class Neo4jPersistentEntity<T>
extends BasicPersistentEntity<T, Neo4jPersistentProperty> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jPersistentEntity.class);

    public Neo4jPersistentEntity(TypeInformation<T> information) {
        super(information);
    }

    protected Neo4jPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(Neo4jPersistentProperty property) {
        Neo4jPersistentProperty existingIdProperty;
        if (!property.isIdProperty()) {
            return null;
        }
        Neo4jPersistentProperty preferredIdProperty = existingIdProperty = (Neo4jPersistentProperty)this.getIdProperty();
        if (existingIdProperty == null) {
            preferredIdProperty = property;
        } else {
            if (existingIdProperty.getPropertyType() == property.getPropertyType()) {
                throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), existingIdProperty.getField()));
            }
            if (existingIdProperty.getPropertyType() == Neo4jPersistentProperty.PropertyType.INTERNAL_ID_PROPERTY && property.getPropertyType() == Neo4jPersistentProperty.PropertyType.ID_PROPERTY) {
                preferredIdProperty = property;
            }
        }
        return preferredIdProperty;
    }

    public boolean hasVersionProperty() {
        logger.debug("[entity].hasVersionProperty() returns false");
        return false;
    }

    public Neo4jPersistentProperty getVersionProperty() {
        logger.debug("[entity].getVersionProperty() returns null");
        return null;
    }

    public boolean isVersionProperty(PersistentProperty<?> property) {
        logger.debug("[entity].isIdProperty({}) returns false", property);
        return false;
    }
}

