/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.util.Assert;

public class SearchResourceMappings
implements Iterable<MethodResourceMapping>,
ResourceMapping {
    private static final String AMBIGUOUS_MAPPING = "Ambiguous search mapping detected. Both %s and %s are mapped to %s! Tweak configuration to get to unambiguous paths!";
    private static final Path PATH = new Path("/search");
    private static final String REL = "search";
    private final Map<Path, MethodResourceMapping> mappings;

    public SearchResourceMappings(List<MethodResourceMapping> mappings) {
        Assert.notNull(mappings, (String)"MethodResourceMappings must not be null!");
        this.mappings = new HashMap<Path, MethodResourceMapping>(mappings.size());
        for (MethodResourceMapping mapping : mappings) {
            MethodResourceMapping existing = this.mappings.get(mapping.getPath());
            if (existing != null) {
                throw new IllegalStateException(String.format(AMBIGUOUS_MAPPING, existing.getMethod(), mapping.getMethod(), existing.getPath()));
            }
            this.mappings.put(mapping.getPath(), mapping);
        }
    }

    public Method getMappedMethod(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty!");
        MethodResourceMapping mapping = this.mappings.get(new Path(path));
        return mapping == null ? null : mapping.getMethod();
    }

    public Iterable<MethodResourceMapping> getExportedMappings() {
        HashSet<MethodResourceMapping> result = new HashSet<MethodResourceMapping>(this.mappings.values().size());
        for (MethodResourceMapping mapping : this) {
            if (!mapping.isExported()) continue;
            result.add(mapping);
        }
        return result;
    }

    public MethodResourceMapping getExportedMethodMappingForRel(String rel) {
        Assert.hasText((String)rel, (String)"Rel must not be null or empty!");
        for (MethodResourceMapping mapping : this) {
            if (!mapping.isExported() || !mapping.getRel().equals(rel)) continue;
            return mapping;
        }
        return null;
    }

    public MethodResourceMapping getExportedMethodMappingForPath(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty!");
        for (MethodResourceMapping mapping : this) {
            if (!mapping.isExported() || !mapping.getPath().matches(path)) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public Path getPath() {
        return PATH;
    }

    @Override
    public String getRel() {
        return REL;
    }

    @Override
    public boolean isExported() {
        return !this.mappings.isEmpty();
    }

    @Override
    public boolean isPagingResource() {
        return false;
    }

    @Override
    public ResourceDescription getDescription() {
        return null;
    }

    @Override
    public Iterator<MethodResourceMapping> iterator() {
        return this.mappings.values().iterator();
    }
}

