/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.integration.support.management.AbstractMessageChannelMetrics;
import org.springframework.integration.support.management.ConfigurableMetricsAware;
import org.springframework.integration.support.management.DefaultMessageChannelMetrics;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.integration.support.management.IntegrationManagement;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.messaging.Message;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@IntegrationManagedResource
public class NullChannel
implements PollableChannel,
MessageChannelMetrics,
ConfigurableMetricsAware<AbstractMessageChannelMetrics>,
BeanNameAware,
NamedComponent {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final IntegrationManagement.ManagementOverrides managementOverrides = new IntegrationManagement.ManagementOverrides();
    private volatile AbstractMessageChannelMetrics channelMetrics = new DefaultMessageChannelMetrics("nullChannel");
    private volatile boolean countsEnabled;
    private volatile boolean statsEnabled;
    private volatile boolean loggingEnabled = true;
    private String beanName;
    private MeterRegistry meterRegistry;
    private Timer successTimer;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
        this.channelMetrics = new DefaultMessageChannelMetrics(this.getComponentName());
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        this.managementOverrides.loggingConfigured = true;
    }

    @Override
    public String getComponentName() {
        return StringUtils.hasText((String)this.beanName) ? this.beanName : "nullChannel";
    }

    @Override
    public String getComponentType() {
        return "channel";
    }

    @Override
    public void registerMeterRegistry(MeterRegistry registry) {
        this.meterRegistry = registry;
    }

    @Override
    public void configureMetrics(AbstractMessageChannelMetrics metrics) {
        Assert.notNull((Object)metrics, (String)"'metrics' must not be null");
        this.channelMetrics = metrics;
        this.managementOverrides.metricsConfigured = true;
    }

    @Override
    public void reset() {
        this.channelMetrics.reset();
    }

    @Override
    public void setCountsEnabled(boolean countsEnabled) {
        this.countsEnabled = countsEnabled;
        this.managementOverrides.countsConfigured = true;
        if (!countsEnabled) {
            this.statsEnabled = false;
            this.managementOverrides.statsConfigured = true;
        }
    }

    @Override
    public boolean isCountsEnabled() {
        return this.countsEnabled;
    }

    @Override
    public void setStatsEnabled(boolean statsEnabled) {
        if (statsEnabled) {
            this.countsEnabled = true;
            this.managementOverrides.countsConfigured = true;
        }
        this.statsEnabled = statsEnabled;
        this.channelMetrics.setFullStatsEnabled(statsEnabled);
        this.managementOverrides.statsConfigured = true;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    @Override
    public int getSendCount() {
        return this.channelMetrics.getSendCount();
    }

    @Override
    public long getSendCountLong() {
        return this.channelMetrics.getSendCountLong();
    }

    @Override
    public int getSendErrorCount() {
        return this.channelMetrics.getSendErrorCount();
    }

    @Override
    public long getSendErrorCountLong() {
        return this.channelMetrics.getSendErrorCountLong();
    }

    @Override
    public double getTimeSinceLastSend() {
        return this.channelMetrics.getTimeSinceLastSend();
    }

    @Override
    public double getMeanSendRate() {
        return this.channelMetrics.getMeanSendRate();
    }

    @Override
    public double getMeanErrorRate() {
        return this.channelMetrics.getMeanErrorRate();
    }

    @Override
    public double getMeanErrorRatio() {
        return this.channelMetrics.getMeanErrorRatio();
    }

    @Override
    public double getMeanSendDuration() {
        return this.channelMetrics.getMeanSendDuration();
    }

    @Override
    public double getMinSendDuration() {
        return this.channelMetrics.getMinSendDuration();
    }

    @Override
    public double getMaxSendDuration() {
        return this.channelMetrics.getMaxSendDuration();
    }

    @Override
    public double getStandardDeviationSendDuration() {
        return this.channelMetrics.getStandardDeviationSendDuration();
    }

    @Override
    public Statistics getSendDuration() {
        return this.channelMetrics.getSendDuration();
    }

    @Override
    public Statistics getSendRate() {
        return this.channelMetrics.getSendRate();
    }

    @Override
    public Statistics getErrorRate() {
        return this.channelMetrics.getErrorRate();
    }

    @Override
    public IntegrationManagement.ManagementOverrides getOverrides() {
        return this.managementOverrides;
    }

    public boolean send(Message<?> message, long timeout) {
        return this.send(message);
    }

    public boolean send(Message<?> message) {
        if (this.loggingEnabled && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("message sent to null channel: " + message));
        }
        if (this.countsEnabled) {
            if (this.meterRegistry != null) {
                this.sendTimer().record(0L, TimeUnit.MILLISECONDS);
            }
            this.channelMetrics.afterSend(this.channelMetrics.beforeSend(), true);
        }
        return true;
    }

    private Timer sendTimer() {
        if (this.successTimer == null) {
            this.successTimer = Timer.builder((String)"spring.integration.send").tag("type", "channel").tag("name", this.getComponentName() == null ? "unknown" : this.getComponentName()).tag("result", "success").tag("exception", "none").description("Subflow process time").register(this.meterRegistry);
        }
        return this.successTimer;
    }

    public Message<?> receive() {
        if (this.loggingEnabled && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"receive called on null channel");
        }
        return null;
    }

    public Message<?> receive(long timeout) {
        return this.receive();
    }

    public String toString() {
        return this.beanName != null ? this.beanName : super.toString();
    }
}

