/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.Executor;
import org.springframework.integration.channel.AbstractExecutorChannel;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class PublishSubscribeChannel
extends AbstractExecutorChannel {
    private volatile ErrorHandler errorHandler;
    private volatile boolean ignoreFailures;
    private volatile boolean applySequence;
    private volatile int minSubscribers;

    public PublishSubscribeChannel(Executor executor) {
        super(executor);
        this.dispatcher = new BroadcastingDispatcher(executor);
    }

    public PublishSubscribeChannel() {
        this(null);
    }

    @Override
    public String getComponentType() {
        return "publish-subscribe-channel";
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
        this.getDispatcher().setIgnoreFailures(ignoreFailures);
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
        this.getDispatcher().setApplySequence(applySequence);
    }

    public void setMinSubscribers(int minSubscribers) {
        this.minSubscribers = minSubscribers;
        this.getDispatcher().setMinSubscribers(minSubscribers);
    }

    @Override
    public final void onInit() throws Exception {
        super.onInit();
        if (this.executor != null) {
            Assert.state((this.getDispatcher().getHandlerCount() == 0 ? 1 : 0) != 0, (String)"When providing an Executor, you cannot subscribe() until the channel bean is fully initialized by the framework. Do not subscribe in a @Bean definition");
            if (!(this.executor instanceof ErrorHandlingTaskExecutor)) {
                if (this.errorHandler == null) {
                    this.errorHandler = new MessagePublishingErrorHandler(new BeanFactoryChannelResolver(this.getBeanFactory()));
                }
                this.executor = new ErrorHandlingTaskExecutor(this.executor, this.errorHandler);
            }
            this.dispatcher = new BroadcastingDispatcher(this.executor);
            this.getDispatcher().setIgnoreFailures(this.ignoreFailures);
            this.getDispatcher().setApplySequence(this.applySequence);
            this.getDispatcher().setMinSubscribers(this.minSubscribers);
        }
        if (this.maxSubscribers == null) {
            Integer maxSubscribers = this.getIntegrationProperty("spring.integration.channels.maxBroadcastSubscribers", Integer.class);
            this.setMaxSubscribers(maxSubscribers);
        }
        this.getDispatcher().setBeanFactory(this.getBeanFactory());
        this.getDispatcher().setMessageHandlingTaskDecorator(task -> {
            if (this.executorInterceptorsSize > 0) {
                return new AbstractExecutorChannel.MessageHandlingTask(task);
            }
            return task;
        });
    }

    @Override
    protected BroadcastingDispatcher getDispatcher() {
        return (BroadcastingDispatcher)this.dispatcher;
    }
}

