/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.EndpointSpec;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.transaction.TransactionInterceptorBuilder;
import org.springframework.messaging.MessageHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import reactor.util.function.Tuple2;

public abstract class ConsumerEndpointSpec<S extends ConsumerEndpointSpec<S, H>, H extends MessageHandler>
extends EndpointSpec<S, ConsumerEndpointFactoryBean, H> {
    protected final List<Advice> adviceChain = new LinkedList<Advice>();

    protected ConsumerEndpointSpec(H messageHandler) {
        super(messageHandler);
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setAdviceChain(this.adviceChain);
        if (messageHandler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)messageHandler).setAdviceChain(this.adviceChain);
        }
    }

    @Override
    public S phase(int phase) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setPhase(phase);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    public S autoStartup(boolean autoStartup) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setAutoStartup(autoStartup);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    public S poller(PollerMetadata pollerMetadata) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setPollerMetadata(pollerMetadata);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    public S role(String role) {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setRole(role);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S taskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, (String)"'taskScheduler' must not be null");
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setTaskScheduler(taskScheduler);
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S advice(Advice ... advice) {
        this.adviceChain.addAll(Arrays.asList(advice));
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S transactional(PlatformTransactionManager transactionManager) {
        return this.transactional(transactionManager, false);
    }

    public S transactional(PlatformTransactionManager transactionManager, boolean handleMessageAdvice) {
        return this.transactional(new TransactionInterceptorBuilder(handleMessageAdvice).transactionManager(transactionManager).build());
    }

    public S transactional(TransactionInterceptor transactionInterceptor) {
        return this.advice(new Advice[]{transactionInterceptor});
    }

    public S transactional() {
        return this.transactional(false);
    }

    public S transactional(boolean handleMessageAdvice) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptorBuilder(handleMessageAdvice).build();
        this.componentsToRegister.put(transactionInterceptor, null);
        return this.transactional(transactionInterceptor);
    }

    public S requiresReply(boolean requiresReply) {
        this.assertHandler();
        if (this.handler instanceof AbstractReplyProducingMessageHandler) {
            ((AbstractReplyProducingMessageHandler)this.handler).setRequiresReply(requiresReply);
        } else {
            this.logger.warn((Object)"'requiresReply' can be applied only for AbstractReplyProducingMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S sendTimeout(long sendTimeout) {
        this.assertHandler();
        if (this.handler instanceof AbstractMessageProducingHandler) {
            ((AbstractMessageProducingHandler)this.handler).setSendTimeout(sendTimeout);
        } else if (this.handler instanceof AbstractMessageRouter) {
            ((AbstractMessageRouter)this.handler).setSendTimeout(sendTimeout);
        } else {
            this.logger.warn((Object)"'sendTimeout' can be applied only for AbstractMessageProducingHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S order(int order) {
        this.assertHandler();
        if (this.handler instanceof AbstractMessageHandler) {
            ((AbstractMessageHandler)this.handler).setOrder(order);
        } else {
            this.logger.warn((Object)"'order' can be applied only for AbstractMessageHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S async(boolean async) {
        this.assertHandler();
        if (this.handler instanceof AbstractMessageProducingHandler) {
            ((AbstractMessageProducingHandler)this.handler).setAsync(async);
        } else {
            this.logger.warn((Object)"'async' can be applied only for AbstractMessageProducingHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    public S notPropagatedHeaders(String ... headerPatterns) {
        this.assertHandler();
        if (this.handler instanceof AbstractMessageProducingHandler) {
            ((AbstractMessageProducingHandler)this.handler).setNotPropagatedHeaders(headerPatterns);
        } else {
            this.logger.warn((Object)"'headerPatterns' can be applied only for AbstractMessageProducingHandler");
        }
        return (S)((ConsumerEndpointSpec)this._this());
    }

    @Override
    protected Tuple2<ConsumerEndpointFactoryBean, H> doGet() {
        ((ConsumerEndpointFactoryBean)this.endpointFactoryBean).setHandler((MessageHandler)this.handler);
        return super.doGet();
    }
}

