/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.aopalliance.aop.Advice;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.DelayHandler;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public final class DelayerEndpointSpec
extends ConsumerEndpointSpec<DelayerEndpointSpec, DelayHandler> {
    private final List<Advice> delayedAdvice = new LinkedList<Advice>();

    DelayerEndpointSpec(DelayHandler delayHandler) {
        super(delayHandler);
        Assert.notNull((Object)delayHandler, (String)"'delayHandler' must not be null.");
        ((DelayHandler)this.handler).setDelayedAdviceChain(this.delayedAdvice);
    }

    public DelayerEndpointSpec defaultDelay(long defaultDelay) {
        ((DelayHandler)this.handler).setDefaultDelay(defaultDelay);
        return (DelayerEndpointSpec)this._this();
    }

    public DelayerEndpointSpec ignoreExpressionFailures(boolean ignoreExpressionFailures) {
        ((DelayHandler)this.handler).setIgnoreExpressionFailures(ignoreExpressionFailures);
        return (DelayerEndpointSpec)this._this();
    }

    public DelayerEndpointSpec messageStore(MessageGroupStore messageStore) {
        ((DelayHandler)this.handler).setMessageStore(messageStore);
        return (DelayerEndpointSpec)this._this();
    }

    public DelayerEndpointSpec delayedAdvice(Advice ... advice) {
        this.delayedAdvice.addAll(Arrays.asList(advice));
        return (DelayerEndpointSpec)this._this();
    }

    public DelayerEndpointSpec delayExpression(Expression delayExpression) {
        ((DelayHandler)this.handler).setDelayExpression(delayExpression);
        return this;
    }

    public DelayerEndpointSpec delayExpression(String delayExpression) {
        ((DelayHandler)this.handler).setDelayExpression(PARSER.parseExpression(delayExpression));
        return this;
    }

    public <P> DelayerEndpointSpec delayFunction(Function<Message<P>, Object> delayFunction) {
        ((DelayHandler)this.handler).setDelayExpression(new FunctionExpression<Message<P>>(delayFunction));
        return this;
    }
}

