/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.channel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.interceptor.WireTap;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.dsl.channel.WireTapSpec;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.util.Assert;

public abstract class MessageChannelSpec<S extends MessageChannelSpec<S, C>, C extends AbstractMessageChannel>
extends IntegrationComponentSpec<S, C>
implements ComponentsRegistration {
    private final Map<Object, String> componentsToRegister = new LinkedHashMap<Object, String>();
    private final List<Class<?>> datatypes = new ArrayList();
    private final List<ChannelInterceptor> interceptors = new LinkedList<ChannelInterceptor>();
    protected C channel;
    private MessageConverter messageConverter;

    protected MessageChannelSpec() {
    }

    @Override
    protected S id(String id) {
        return (S)((MessageChannelSpec)super.id(id));
    }

    public S datatype(Class<?> ... datatypes) {
        Assert.notNull(datatypes, (String)"'datatypes' must not be null");
        Assert.noNullElements((Object[])datatypes, (String)"'datatypes' must not contain null elements");
        this.datatypes.addAll(Arrays.asList(datatypes));
        return (S)((MessageChannelSpec)this._this());
    }

    public S interceptor(ChannelInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, (String)"'interceptors' must not be null");
        Assert.noNullElements((Object[])interceptors, (String)"'interceptors' must not contain null elements");
        this.interceptors.addAll(Arrays.asList(interceptors));
        return (S)((MessageChannelSpec)this._this());
    }

    public S wireTap(String wireTapChannel) {
        return this.wireTap(new WireTapSpec(wireTapChannel));
    }

    public S wireTap(MessageChannel wireTapChannel) {
        return this.wireTap(new WireTapSpec(wireTapChannel));
    }

    public S wireTap(WireTapSpec wireTapSpec) {
        WireTap interceptor = (WireTap)wireTapSpec.get();
        this.componentsToRegister.put(interceptor, null);
        return this.interceptor(new ChannelInterceptor[]{interceptor});
    }

    public S messageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        return (S)((MessageChannelSpec)this._this());
    }

    @Override
    public Map<Object, String> getComponentsToRegister() {
        return this.componentsToRegister;
    }

    @Override
    protected C doGet() {
        ((AbstractMessageChannel)this.channel).setDatatypes(this.datatypes.toArray(new Class[this.datatypes.size()]));
        ((IntegrationObjectSupport)this.channel).setBeanName(this.getId());
        ((AbstractMessageChannel)this.channel).setInterceptors(this.interceptors);
        ((AbstractMessageChannel)this.channel).setMessageConverter(this.messageConverter);
        return this.channel;
    }
}

