/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.util.Assert;

public abstract class AbstractJsonInboundMessageMapper<P>
implements InboundMessageMapper<String> {
    protected static final String MESSAGE_FORMAT_ERROR = "JSON message is invalid.  Expected a message in the format of either {\"headers\":{...},\"payload\":{...}} or {\"payload\":{...}.\"headers\":{...}} but was ";
    protected static final Map<String, Class<?>> DEFAULT_HEADER_TYPES = new HashMap();
    protected final Type payloadType;
    protected final Map<String, Class<?>> headerTypes = DEFAULT_HEADER_TYPES;
    protected volatile boolean mapToPayload = false;

    public AbstractJsonInboundMessageMapper(Type payloadType) {
        Assert.notNull((Object)payloadType, (String)"payloadType must not be null");
        this.payloadType = payloadType;
    }

    public void setHeaderTypes(Map<String, Class<?>> headerTypes) {
        this.headerTypes.putAll(headerTypes);
    }

    public void setMapToPayload(boolean mapToPayload) {
        this.mapToPayload = mapToPayload;
    }

    protected abstract Object readPayload(P var1, String var2) throws Exception;

    protected abstract Map<String, Object> readHeaders(P var1, String var2) throws Exception;

    static {
        DEFAULT_HEADER_TYPES.put("priority", Integer.class);
        DEFAULT_HEADER_TYPES.put("expirationDate", Long.class);
        DEFAULT_HEADER_TYPES.put("sequenceSize", Integer.class);
        DEFAULT_HEADER_TYPES.put("sequenceNumber", Integer.class);
    }
}

