/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.leader;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;

public class LockRegistryLeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    public static final long DEFAULT_HEART_BEAT_TIME = 500L;
    public static final long DEFAULT_BUSY_WAIT_TIME = 50L;
    private static final Log logger = LogFactory.getLog(LockRegistryLeaderInitiator.class);
    private static final Context NULL_CONTEXT = () -> false;
    private final Object lifecycleMonitor = new Object();
    private final LockRegistry locks;
    private final Candidate candidate;
    private ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("lock-leadership-"));
    private boolean executorServiceExplicitlySet;
    private long heartBeatMillis = 500L;
    private long busyWaitMillis = 50L;
    private boolean publishFailedEvents = false;
    private LeaderSelector leaderSelector;
    private ApplicationEventPublisher applicationEventPublisher;
    private LeaderEventPublisher leaderEventPublisher;
    private boolean autoStartup = true;
    private int phase;
    private volatile boolean running;
    private volatile Future<?> future;

    public LockRegistryLeaderInitiator(LockRegistry locks) {
        this(locks, new DefaultCandidate());
    }

    public LockRegistryLeaderInitiator(LockRegistry locks, Candidate candidate) {
        Assert.notNull((Object)locks, (String)"'locks' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.locks = locks;
        this.candidate = candidate;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.executorServiceExplicitlySet = true;
    }

    public void setHeartBeatMillis(long heartBeatMillis) {
        this.heartBeatMillis = heartBeatMillis;
    }

    public void setBusyWaitMillis(long busyWaitMillis) {
        this.busyWaitMillis = busyWaitMillis;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return NULL_CONTEXT;
        }
        return this.leaderSelector.context;
    }

    public boolean isPublishFailedEvents() {
        return this.publishFailedEvents;
    }

    public void setPublishFailedEvents(boolean publishFailedEvents) {
        this.publishFailedEvents = publishFailedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.leaderEventPublisher == null && this.applicationEventPublisher != null) {
            this.leaderEventPublisher = new DefaultLeaderEventPublisher(this.applicationEventPublisher);
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running) {
                this.leaderSelector = new LeaderSelector(this.buildLeaderPath());
                this.running = true;
                this.future = this.executorService.submit(this.leaderSelector);
                logger.debug((Object)"Started LeaderInitiator");
            }
        }
    }

    public void destroy() {
        this.stop();
        if (!this.executorServiceExplicitlySet) {
            this.executorService.shutdown();
        }
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                if (this.future != null) {
                    this.future.cancel(true);
                }
                this.future = null;
                logger.debug((Object)"Stopped LeaderInitiator");
            }
        }
    }

    private String buildLeaderPath() {
        return this.candidate.getRole();
    }

    private class LockContext
    implements Context {
        LockContext() {
        }

        @Override
        public boolean isLeader() {
            return LockRegistryLeaderInitiator.this.leaderSelector.isLeader();
        }

        @Override
        public void yield() {
            if (LockRegistryLeaderInitiator.this.future != null) {
                LockRegistryLeaderInitiator.this.future.cancel(true);
            }
        }

        public String toString() {
            return "LockContext{role=" + LockRegistryLeaderInitiator.this.candidate.getRole() + ", id=" + LockRegistryLeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }

    protected class LeaderSelector
    implements Callable<Void> {
        private final Lock lock;
        private final String lockKey;
        private final LockContext context;
        private volatile boolean locked;

        LeaderSelector(String lockKey) {
            this.context = new LockContext();
            this.locked = false;
            this.lock = LockRegistryLeaderInitiator.this.locks.obtain(lockKey);
            this.lockKey = lockKey;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws Exception {
            block6: while (true) {
                while (LockRegistryLeaderInitiator.this.isRunning()) {
                    try {
                        boolean acquired = this.lock.tryLock(LockRegistryLeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS);
                        if (!this.locked) {
                            if (acquired) {
                                this.locked = true;
                                this.handleGranted();
                                continue block6;
                            }
                            if (!LockRegistryLeaderInitiator.this.isPublishFailedEvents()) continue block6;
                            this.publishFailedToAcquire();
                            continue block6;
                        }
                        if (acquired) {
                            this.lock.unlock();
                            if (!LockRegistryLeaderInitiator.this.isRunning()) continue block6;
                            Thread.sleep(LockRegistryLeaderInitiator.this.heartBeatMillis);
                            continue block6;
                        }
                        this.locked = false;
                        this.handleRevoked();
                        if (!LockRegistryLeaderInitiator.this.isRunning()) continue block6;
                        Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                    }
                    catch (Exception e) {
                        if (this.locked) {
                            this.lock.unlock();
                            this.locked = false;
                            this.handleRevoked();
                            if (LockRegistryLeaderInitiator.this.isRunning()) {
                                Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                            }
                        }
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            if (LockRegistryLeaderInitiator.this.isRunning()) {
                                logger.warn((Object)"Restarting LeaderSelector because of error.", (Throwable)e);
                                LockRegistryLeaderInitiator.this.future = LockRegistryLeaderInitiator.this.executorService.submit(this);
                            }
                            Void void_ = null;
                            if (this.locked) {
                                this.lock.unlock();
                                this.handleRevoked();
                            }
                            this.locked = false;
                            return void_;
                        }
                        try {
                            continue block6;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                if (this.locked) {
                    this.lock.unlock();
                    this.handleRevoked();
                }
                this.locked = false;
            }
        }

        public boolean isLeader() {
            return this.locked;
        }

        private void handleGranted() throws InterruptedException {
            LockRegistryLeaderInitiator.this.candidate.onGranted(this.context);
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnGranted(LockRegistryLeaderInitiator.this, this.context, this.lockKey);
                }
                catch (Exception e) {
                    logger.warn((Object)"Error publishing OnGranted event.", (Throwable)e);
                }
            }
        }

        private void handleRevoked() {
            LockRegistryLeaderInitiator.this.candidate.onRevoked(this.context);
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnRevoked(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                }
                catch (Exception e) {
                    logger.warn((Object)"Error publishing OnRevoked event.", (Throwable)e);
                }
            }
        }

        private void publishFailedToAcquire() {
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnFailedToAcquire(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                }
                catch (Exception e) {
                    logger.warn((Object)"Error publishing OnFailedToAcquire event.", (Throwable)e);
                }
            }
        }
    }
}

