/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.support.management.ConfigurableMetrics;
import org.springframework.integration.support.management.MetricsContext;
import org.springframework.integration.support.management.Statistics;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractMessageChannelMetrics
implements ConfigurableMetrics {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final String name;
    private final Timer timer;
    private final Counter errorCounter;
    private final Counter receiveCounter;
    private final Counter receiveErrorCounter;
    private volatile boolean fullStatsEnabled;

    public AbstractMessageChannelMetrics(String name) {
        this(name, null, null, null, null);
    }

    public AbstractMessageChannelMetrics(String name, Timer timer, Counter errorCounter, Counter receiveCounter, Counter receiveErrorCounter) {
        if (timer != null) {
            Assert.notNull((Object)errorCounter, (String)"'errorCounter' cannot be null if a timer is provided");
        }
        this.name = name;
        this.timer = timer;
        this.errorCounter = errorCounter;
        this.receiveCounter = receiveCounter;
        this.receiveErrorCounter = receiveErrorCounter;
    }

    public void setFullStatsEnabled(boolean fullStatsEnabled) {
        this.fullStatsEnabled = fullStatsEnabled;
    }

    protected boolean isFullStatsEnabled() {
        return this.fullStatsEnabled;
    }

    public abstract MetricsContext beforeSend();

    public abstract void afterSend(MetricsContext var1, boolean var2);

    public abstract void reset();

    @Nullable
    public Timer getTimer() {
        return this.timer;
    }

    @Nullable
    public Counter getErrorCounter() {
        return this.errorCounter;
    }

    @Nullable
    public Counter getReceiveCounter() {
        return this.receiveCounter;
    }

    @Nullable
    public Counter getReceiveErrorCounter() {
        return this.receiveErrorCounter;
    }

    public abstract int getSendCount();

    public abstract long getSendCountLong();

    public abstract int getSendErrorCount();

    public abstract long getSendErrorCountLong();

    public abstract double getTimeSinceLastSend();

    public abstract double getMeanSendRate();

    public abstract double getMeanErrorRate();

    public abstract double getMeanErrorRatio();

    public abstract double getMeanSendDuration();

    public abstract double getMinSendDuration();

    public abstract double getMaxSendDuration();

    public abstract double getStandardDeviationSendDuration();

    public abstract Statistics getSendDuration();

    public abstract Statistics getSendRate();

    public abstract Statistics getErrorRate();

    public abstract void afterReceive();

    public abstract void afterError();

    public abstract int getReceiveCount();

    public abstract long getReceiveCountLong();

    public abstract int getReceiveErrorCount();

    public abstract long getReceiveErrorCountLong();
}

