/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.MethodArgsMessageMapper;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationGatewayProxyFactoryBean
extends GatewayProxyFactoryBean {
    private final AnnotationAttributes gatewayAttributes;

    public AnnotationGatewayProxyFactoryBean(Class<?> serviceInterface) {
        super(serviceInterface);
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes(serviceInterface, (String)MessagingGateway.class.getName(), (boolean)false, (boolean)true);
        if (annotationAttributes == null) {
            annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)AnnotationUtils.synthesizeAnnotation(MessagingGateway.class), (boolean)false, (boolean)true);
        }
        this.gatewayAttributes = annotationAttributes;
        String id = annotationAttributes.getString("name");
        if (StringUtils.hasText((String)id)) {
            this.setBeanName(id);
        }
    }

    @Override
    protected void onInit() {
        String defaultReplyChannel;
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)this.getBeanFactory();
        String defaultPayloadExpression = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("defaultPayloadExpression"));
        Object[] defaultHeaders = (Map[])this.gatewayAttributes.get((Object)"defaultHeaders");
        String mapper = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("mapper"));
        boolean hasMapper = StringUtils.hasText((String)mapper);
        boolean hasDefaultPayloadExpression = StringUtils.hasText((String)defaultPayloadExpression);
        Assert.state((!hasMapper || !hasDefaultPayloadExpression ? 1 : 0) != 0, (String)"'defaultPayloadExpression' is not allowed when a 'mapper' is provided");
        boolean hasDefaultHeaders = !ObjectUtils.isEmpty((Object[])defaultHeaders);
        Assert.state((!hasMapper || !hasDefaultHeaders ? 1 : 0) != 0, (String)"'defaultHeaders' are not allowed when a 'mapper' is provided");
        String defaultRequestChannel = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("defaultRequestChannel"));
        if (StringUtils.hasText((String)defaultRequestChannel)) {
            this.setDefaultRequestChannelName(defaultRequestChannel);
        }
        if (StringUtils.hasText((String)(defaultReplyChannel = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("defaultReplyChannel"))))) {
            this.setDefaultReplyChannelName(defaultReplyChannel);
        }
        String errorChannel = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("errorChannel"));
        this.setErrorChannelName(errorChannel);
        String asyncExecutor = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("asyncExecutor"));
        if (asyncExecutor == null || "__NULL__".equals(asyncExecutor)) {
            this.setAsyncExecutor(null);
        } else if (StringUtils.hasText((String)asyncExecutor)) {
            this.setAsyncExecutor((Executor)beanFactory.getBean(asyncExecutor, Executor.class));
        }
        if (hasDefaultHeaders || hasDefaultPayloadExpression) {
            GatewayMethodMetadata gatewayMethodMetadata = new GatewayMethodMetadata();
            if (hasDefaultPayloadExpression) {
                gatewayMethodMetadata.setPayloadExpression(defaultPayloadExpression);
            }
            HashMap<String, Expression> headerExpressions = new HashMap<String, Expression>();
            for (Object header : defaultHeaders) {
                String headerExpression;
                String headerValue = beanFactory.resolveEmbeddedValue((String)header.get("value"));
                boolean hasValue = StringUtils.hasText((String)headerValue);
                Assert.state((hasValue != StringUtils.hasText((String)(headerExpression = beanFactory.resolveEmbeddedValue((String)header.get("expression")))) ? 1 : 0) != 0, (String)"exactly one of 'value' or 'expression' is required on a gateway's header.");
                LiteralExpression expression = hasValue ? new LiteralExpression(headerValue) : EXPRESSION_PARSER.parseExpression(headerExpression);
                String headerName = beanFactory.resolveEmbeddedValue((String)header.get("name"));
                headerExpressions.put(headerName, (Expression)expression);
            }
            gatewayMethodMetadata.setHeaderExpressions(headerExpressions);
            this.setGlobalMethodMetadata(gatewayMethodMetadata);
        }
        if (StringUtils.hasText((String)mapper)) {
            this.setMapper((MethodArgsMessageMapper)beanFactory.getBean(mapper, MethodArgsMessageMapper.class));
        }
        String defaultRequestTimeout = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("defaultRequestTimeout"));
        this.setDefaultRequestTimeout(Long.parseLong(defaultRequestTimeout));
        String defaultReplyTimeout = beanFactory.resolveEmbeddedValue(this.gatewayAttributes.getString("defaultReplyTimeout"));
        this.setDefaultReplyTimeout(Long.parseLong(defaultReplyTimeout));
        super.onInit();
    }
}

