/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.slots.block.flow.param.RollingParamEvent;
import com.alibaba.csp.sentinel.slots.statistic.metric.HotParameterLeapArray;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParameterMetric {
    private Map<Integer, HotParameterLeapArray> rollingParameters = new ConcurrentHashMap<Integer, HotParameterLeapArray>();

    public Map<Integer, HotParameterLeapArray> getRollingParameters() {
        return this.rollingParameters;
    }

    public synchronized void clear() {
        this.rollingParameters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeForIndex(int index) {
        if (!this.rollingParameters.containsKey(index)) {
            ParameterMetric parameterMetric = this;
            synchronized (parameterMetric) {
                if (this.rollingParameters.get(index) == null) {
                    this.rollingParameters.put(index, new HotParameterLeapArray(1000 / SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL));
                }
            }
        }
    }

    public void addPass(int count, Object ... args) {
        this.add(RollingParamEvent.REQUEST_PASSED, count, args);
    }

    public void addBlock(int count, Object ... args) {
        this.add(RollingParamEvent.REQUEST_BLOCKED, count, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void add(RollingParamEvent event, int count, Object ... args) {
        if (args == null) {
            return;
        }
        try {
            int index = 0;
            while (index < args.length) {
                Object arg;
                HotParameterLeapArray param = this.rollingParameters.get(index);
                if (param != null && (arg = args[index]) != null) {
                    if (Collection.class.isAssignableFrom(arg.getClass())) {
                        for (Object value : (Collection)arg) {
                            param.addValue(event, count, value);
                        }
                    } else if (arg.getClass().isArray()) {
                        int length = Array.getLength(arg);
                        for (int i = 0; i < length; ++i) {
                            Object value = Array.get(arg, i);
                            param.addValue(event, count, value);
                        }
                    } else {
                        param.addValue(event, count, arg);
                    }
                }
                ++index;
            }
            return;
        }
        catch (Throwable e) {
            RecordLog.warn((String)"[ParameterMetric] Param exception", (Throwable)e);
        }
    }

    public double getPassParamQps(int index, Object value) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null || value == null) {
                return -1.0;
            }
            return parameter.getRollingAvg(RollingParamEvent.REQUEST_PASSED, value);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return -1.0;
        }
    }

    public long getBlockParamQps(int index, Object value) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null || value == null) {
                return -1L;
            }
            return (long)this.rollingParameters.get(index).getRollingAvg(RollingParamEvent.REQUEST_BLOCKED, value);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public Map<Object, Double> getTopPassParamCount(int index, int number) {
        try {
            HotParameterLeapArray parameter = this.rollingParameters.get(index);
            if (parameter == null) {
                return new HashMap<Object, Double>();
            }
            return parameter.getTopValues(RollingParamEvent.REQUEST_PASSED, number);
        }
        catch (Throwable e) {
            RecordLog.info((String)e.getMessage(), (Throwable)e);
            return new HashMap<Object, Double>();
        }
    }
}

