/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.metric;

import com.alibaba.csp.sentinel.slots.block.flow.param.RollingParamEvent;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.slots.statistic.data.ParamMapBucket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HotParameterLeapArray
extends LeapArray<ParamMapBucket> {
    private int intervalInSec;

    public HotParameterLeapArray(int windowLengthInMs, int intervalInSec) {
        super(windowLengthInMs, intervalInSec);
        this.intervalInSec = intervalInSec;
    }

    public int getIntervalInSec() {
        return this.intervalInSec;
    }

    public ParamMapBucket newEmptyBucket() {
        return new ParamMapBucket();
    }

    protected WindowWrap<ParamMapBucket> resetWindowTo(WindowWrap<ParamMapBucket> w, long startTime) {
        w.resetTo(startTime);
        ((ParamMapBucket)w.value()).reset();
        return w;
    }

    public void addValue(RollingParamEvent event, int count, Object value) {
        ((ParamMapBucket)this.currentWindow().value()).add(event, count, value);
    }

    public Map<Object, Double> getTopValues(RollingParamEvent event, int number) {
        Map.Entry x;
        this.currentWindow();
        List buckets = this.values();
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        for (ParamMapBucket b : buckets) {
            Set<Object> subSet = b.ascendingKeySet(event);
            for (Object o : subSet) {
                Integer count = (Integer)result.get(o);
                count = count == null ? Integer.valueOf(b.get(event, o)) : Integer.valueOf(count + b.get(event, o));
                result.put(o, count);
            }
        }
        Set set = result.entrySet();
        ArrayList list = new ArrayList(set);
        Collections.sort(list, new Comparator<Map.Entry<Object, Integer>>(){

            @Override
            public int compare(Map.Entry<Object, Integer> a, Map.Entry<Object, Integer> b) {
                return (b.getValue() == null ? 0 : b.getValue()) - (a.getValue() == null ? 0 : a.getValue());
            }
        });
        HashMap<Object, Double> doubleResult = new HashMap<Object, Double>();
        int size = list.size() > number ? number : list.size();
        for (int i = 0; i < size && (Integer)(x = (Map.Entry)list.get(i)).getValue() != 0; ++i) {
            doubleResult.put(x.getKey(), (double)((Integer)x.getValue()).intValue() / (double)this.getIntervalInSec());
        }
        return doubleResult;
    }

    public long getRollingSum(RollingParamEvent event, Object value) {
        this.currentWindow();
        long sum = 0L;
        List buckets = this.values();
        for (ParamMapBucket b : buckets) {
            sum += (long)b.get(event, value);
        }
        return sum;
    }

    public double getRollingAvg(RollingParamEvent event, Object value) {
        return (double)this.getRollingSum(event, value) / (double)this.getIntervalInSec();
    }
}

