/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.commons;

import com.dragome.commons.InstrumentationDragomeConfigurator;
import com.dragome.commons.compiler.BytecodeTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChainedInstrumentationDragomeConfigurator
extends InstrumentationDragomeConfigurator {
    protected List<InstrumentationDragomeConfigurator> configurators = new ArrayList<InstrumentationDragomeConfigurator>();

    public void init(InstrumentationDragomeConfigurator ... configurators) {
        this.configurators = Arrays.asList(configurators);
        for (InstrumentationDragomeConfigurator configurator : this.configurators) {
            if (!configurator.isEnabled()) continue;
            this.includedPaths.addAll(configurator.getIncludedPaths());
            this.loadedFromParent.addAll(configurator.getLoadedFromParent());
        }
    }

    @Override
    public BytecodeTransformer getBytecodeTransformer() {
        if (this.configurators.isEmpty()) {
            return super.getBytecodeTransformer();
        }
        return new BytecodeTransformer(){

            @Override
            public byte[] transform(String className, byte[] bytecode) {
                byte[] transformedBytecode = bytecode;
                for (InstrumentationDragomeConfigurator configurator : ChainedInstrumentationDragomeConfigurator.this.configurators) {
                    if (!configurator.isEnabled()) continue;
                    transformedBytecode = configurator.getBytecodeTransformer().transform(className, transformedBytecode);
                }
                return transformedBytecode;
            }

            @Override
            public boolean requiresTransformation(String className) {
                boolean transform = false;
                for (InstrumentationDragomeConfigurator configurator : ChainedInstrumentationDragomeConfigurator.this.configurators) {
                    if (!configurator.isEnabled()) continue;
                    transform |= configurator.getBytecodeTransformer().requiresTransformation(className);
                }
                return transform;
            }
        };
    }

    @Override
    public boolean filterClassPath(String classpathEntry) {
        boolean result = false;
        if (this.configurators.isEmpty()) {
            result = super.filterClassPath(classpathEntry);
        } else {
            for (InstrumentationDragomeConfigurator configurator : this.configurators) {
                result |= configurator.filterClassPath(classpathEntry);
            }
        }
        return result;
    }
}

