/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.commons;

import com.dragome.commons.DragomeConfigurator;
import com.dragome.commons.DragomeConfiguratorImplementor;
import com.dragome.commons.ExecutionHandler;
import com.dragome.commons.compiler.BytecodeTransformer;
import com.dragome.commons.compiler.annotations.CompilerType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

@DragomeConfiguratorImplementor
public class DefaultDragomeConfigurator
implements DragomeConfigurator {
    private CompilerType defaultCompilerType = CompilerType.Standard;
    private FileFilter classpathFilter;

    @Override
    public ClassLoader getNewClassloaderInstance(ClassLoader parent, ClassLoader current) {
        return current;
    }

    @Override
    public BytecodeTransformer getBytecodeTransformer() {
        return new BytecodeTransformer(){

            @Override
            public byte[] transform(String className, byte[] bytecode) {
                return bytecode;
            }

            @Override
            public boolean requiresTransformation(String className) {
                return false;
            }
        };
    }

    @Override
    public ExecutionHandler getExecutionHandler() {
        return new ExecutionHandler(){

            @Override
            public void suspendExecution() {
            }

            @Override
            public boolean canSuspend() {
                return false;
            }

            @Override
            public Executor getExecutor() {
                return new Executor(){

                    @Override
                    public void execute(Runnable command) {
                        command.run();
                    }
                };
            }

            @Override
            public void continueExecution() {
            }
        };
    }

    @Override
    public boolean filterClassPath(String classpathEntry) {
        boolean include = classpathEntry.contains("dragome-js-jre-") || classpathEntry.contains("dragome-js-commons-") || classpathEntry.contains("dragome-core-") || classpathEntry.contains("dragome-guia-") || classpathEntry.contains("dragome-form-bindings-") || classpathEntry.contains("dragome-method-logger-") || classpathEntry.contains("dragome-web-");
        return include;
    }

    @Override
    public CompilerType getDefaultCompilerType() {
        return this.defaultCompilerType;
    }

    @Override
    public void setDefaultCompilerType(CompilerType defaultCompilerType) {
        this.defaultCompilerType = defaultCompilerType;
    }

    @Override
    public FileFilter getClasspathFilter() {
        return this.classpathFilter;
    }

    public void setClasspathFilter(FileFilter classpathFilter) {
        this.classpathFilter = classpathFilter;
    }

    @Override
    public boolean isCheckingCast() {
        return true;
    }

    @Override
    public List<File> getExtraClasspath(String classpath) {
        return new ArrayList<File>();
    }
}

