/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.commons;

import com.dragome.commons.compiler.BytecodeTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class DragomeInstrumentationClassLoader
extends URLClassLoader {
    private static Logger LOGGER = Logger.getLogger(DragomeInstrumentationClassLoader.class.getName());
    private boolean parentFirst = true;
    private List systemPackages = new ArrayList();
    private List loaderPackages = new ArrayList();
    private boolean ignoreBase = false;
    private final AccessControlContext acc;
    private static final int BUFFER_SIZE = 4096;
    protected Set<String> loadFromParent = new HashSet<String>();
    private Map<String, byte[]> bytecodes = new HashMap<String, byte[]>();
    private List<String> loadingClass = new ArrayList<String>();
    private ClassLoader last;
    private BytecodeTransformer bytecodeTransformer;

    public DragomeInstrumentationClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, DragomeInstrumentationClassLoader.fixNullParent(parent));
        this.acc = AccessController.getContext();
    }

    public DragomeInstrumentationClassLoader(URL[] urls, ClassLoader parent, ClassLoader last, BytecodeTransformer bytecodeTransformer, Set<String> loadFromParentList) {
        this(urls, parent);
        this.loadFromParent = loadFromParentList;
        this.last = last;
        this.bytecodeTransformer = bytecodeTransformer;
    }

    private static ClassLoader fixNullParent(ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        return DragomeInstrumentationClassLoader.getSystemClassLoader();
    }

    public void setParentFirst(boolean parentFirst) {
        this.parentFirst = parentFirst;
    }

    public void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    public synchronized void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.add(this.appendDot(packageRoot));
    }

    public synchronized void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.add(packageRoot);
    }

    public synchronized void addLoadFromParent(String packageRoot) {
        this.loadFromParent.add(packageRoot);
    }

    private String appendDot(String str) {
        if (str.endsWith(".")) {
            str = str + '.';
        }
        return str;
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        LOGGER.finest("force loading " + classname);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    private synchronized boolean isParentFirst(String resourceName) {
        boolean useParentFirst = this.parentFirst;
        for (String packageName : this.systemPackages) {
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        for (String packageName : this.loaderPackages) {
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> theClass = this.findLoadedClass(classname);
            byte[] bs = this.bytecodes.get(classname);
            if (bs != null) {
                theClass = this.defineClassFromData(bs, classname);
            }
            if (theClass != null) {
                Class<?> clazz = theClass;
                return clazz;
            }
            if (this.classNeedsLoadingFromParent(classname)) {
                try {
                    theClass = this.getParent().loadClass(classname);
                    LOGGER.finest("Class " + classname + " loaded from parent loader " + "(parentFirst)");
                }
                catch (ClassNotFoundException cnfe) {
                    theClass = this.findClass(classname);
                    LOGGER.finest("Class " + classname + " loaded from ant loader " + "(parentFirst)");
                }
            } else {
                try {
                    theClass = this.findClass(classname);
                    LOGGER.finest("Class " + classname + " loaded from ant loader");
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.ignoreBase) {
                        throw cnfe;
                    }
                    theClass = this.getParent().loadClass(classname);
                    LOGGER.finest("Class " + classname + " loaded from parent loader");
                }
            }
            if (resolve) {
                this.resolveClass(theClass);
            }
            Class<?> clazz = theClass;
            return clazz;
        }
        finally {
            this.loadingClass.remove(classname);
        }
    }

    private boolean classNeedsLoadingFromParent(String classname) {
        for (String packageName : this.loadFromParent) {
            if (!classname.startsWith(packageName)) continue;
            return true;
        }
        return classname.startsWith("javassist.") || classname.startsWith("junit.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("org.w3c") || classname.startsWith("org.xml") || this.loadFromParent.contains(classname) || classname.startsWith("org.apache");
    }

    public Class defineClassFromData(final byte[] classData, final String classname) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                byte[] newData;
                String packageName;
                Package pkg;
                int i = classname.lastIndexOf(46);
                if (i > 0 && (pkg = DragomeInstrumentationClassLoader.this.getPackage(packageName = classname.substring(0, i))) == null) {
                    DragomeInstrumentationClassLoader.this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                if (DragomeInstrumentationClassLoader.this.bytecodeTransformer == null || !DragomeInstrumentationClassLoader.this.bytecodeTransformer.requiresTransformation(classname) || DragomeInstrumentationClassLoader.this.loadingClass.contains(classname)) {
                    newData = classData;
                } else {
                    DragomeInstrumentationClassLoader.this.loadingClass.add(classname);
                    Thread.currentThread().setContextClassLoader(DragomeInstrumentationClassLoader.this.last);
                    newData = DragomeInstrumentationClassLoader.this.bytecodeTransformer.transform(classname, classData);
                    Thread.currentThread().setContextClassLoader(DragomeInstrumentationClassLoader.this);
                }
                ProtectionDomain domain = this.getClass().getProtectionDomain();
                return DragomeInstrumentationClassLoader.this.defineClass(classname, newData, 0, newData.length, domain);
            }
        }, this.acc);
    }

    private Class getClassFromStream(InputStream stream, String classname) throws IOException, SecurityException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = stream.read(buffer, 0, 4096)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        return this.defineClassFromData(classData, classname);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        LOGGER.finest("Finding class " + name);
        String classFileName = name.replace('.', '/') + ".class";
        InputStream stream = this.getResourceAsStream(classFileName);
        if (stream == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            Class clazz = this.getClassFromStream(stream, name);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public synchronized URL getResource(String name) {
        if (this.isParentFirst(name)) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    public void addLoaderPackagesRoot(String[] packagesroot) {
        for (String packageroot : packagesroot) {
            this.addLoaderPackageRoot(packageroot);
        }
    }

    public void addClassBytecode(byte[] bytecode, String aName) {
        this.bytecodes.put(aName, bytecode);
    }

    public void setBytecodes(Map<String, byte[]> bytecodes) {
        this.bytecodes = bytecodes;
    }
}

