/*
 * Decompiled with CFR 0.152.
 */
package com.dragome.methodlogger.serverside;

import com.dragome.commons.compiler.BytecodeTransformer;
import com.dragome.methodlogger.serverside.MethodLoggerAdapter;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MethodLoggerBytecodeTransformer
implements BytecodeTransformer {
    protected Set<String> includePathsList;
    private boolean enabled;

    public MethodLoggerBytecodeTransformer(Set<String> includePathsList, boolean enabled) {
        this.includePathsList = includePathsList;
        this.enabled = enabled;
    }

    public boolean requiresTransformation(String className) {
        if (!this.enabled) {
            return false;
        }
        for (String path : this.includePathsList) {
            if (!className.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String className, byte[] bytecode) {
        if (this.requiresTransformation(className)) {
            ClassNode classNode = new ClassNode(327680);
            MethodLoggerAdapter invokeDynamicConverter = new MethodLoggerAdapter((ClassVisitor)classNode);
            new ClassReader(bytecode).accept((ClassVisitor)invokeDynamicConverter, 8);
            ClassWriter cw = new ClassWriter(1);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return bytecode;
    }
}

