/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.FluxOperator;
import io.micrometer.shaded.reactor.core.publisher.InnerOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.Signal;
import io.micrometer.shaded.reactor.core.publisher.SignalType;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.function.Consumer;

final class FluxDoOnEach<T>
extends FluxOperator<T, T> {
    final Consumer<? super Signal<T>> onSignal;

    FluxDoOnEach(Flux<? extends T> source, Consumer<? super Signal<T>> onSignal) {
        super(source);
        this.onSignal = Objects.requireNonNull(onSignal, "onSignal");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new DoOnEachSubscriber<T>(actual, this.onSignal));
    }

    static final class DoOnEachSubscriber<T>
    implements InnerOperator<T, T>,
    Signal<T> {
        final CoreSubscriber<? super T> actual;
        final Context cachedContext;
        final Consumer<? super Signal<T>> onSignal;
        T t;
        Subscription s;
        boolean done;

        DoOnEachSubscriber(CoreSubscriber<? super T> actual, Consumer<? super Signal<T>> onSignal) {
            this.actual = actual;
            this.cachedContext = actual.currentContext();
            this.onSignal = onSignal;
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.onSubscribe(this);
        }

        @Override
        public Context currentContext() {
            return this.cachedContext;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.cachedContext);
                return;
            }
            try {
                this.t = t;
                this.onSignal.accept(this);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t, this.cachedContext));
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            block5: {
                if (this.done) {
                    Operators.onErrorDropped(t, this.cachedContext);
                    return;
                }
                this.done = true;
                try {
                    this.onSignal.accept(Signal.error(t, this.cachedContext));
                }
                catch (Throwable e) {
                    t = Operators.onOperatorError(null, e, t, this.cachedContext);
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t) break block5;
                    throw use;
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            try {
                this.onSignal.accept(Signal.complete(this.cachedContext));
            }
            catch (Throwable e) {
                this.done = false;
                this.onError(Operators.onOperatorError(this.s, e, this.cachedContext));
                return;
            }
            this.actual.onComplete();
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Throwable getThrowable() {
            return null;
        }

        @Override
        @Nullable
        public Subscription getSubscription() {
            return null;
        }

        @Override
        @Nullable
        public T get() {
            return this.t;
        }

        @Override
        public Context getContext() {
            return this.cachedContext;
        }

        @Override
        public SignalType getType() {
            return SignalType.ON_NEXT;
        }

        public String toString() {
            return "doOnEach_onNext(" + this.t + ")";
        }
    }
}

