/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.AssemblyOp;
import io.micrometer.shaded.reactor.core.publisher.FluxOnAssembly;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.concurrent.Callable;

final class MonoCallableOnAssembly<T>
extends MonoOperator<T, T>
implements Callable<T>,
AssemblyOp {
    final FluxOnAssembly.AssemblySnapshotException stacktrace = new FluxOnAssembly.AssemblySnapshotException();

    MonoCallableOnAssembly(Mono<? extends T> source) {
        super(source);
    }

    @Override
    @Nullable
    public T block() {
        return this.block(Duration.ZERO);
    }

    @Override
    @Nullable
    public T block(Duration timeout) {
        try {
            return (T)((Callable)((Object)this.source)).call();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new FluxOnAssembly.OnAssemblyConditionalSubscriber(cs, this.stacktrace, (Publisher<?>)this.source));
        } else {
            this.source.subscribe(new FluxOnAssembly.OnAssemblySubscriber<T>(actual, this.stacktrace, this.source));
        }
    }

    @Override
    @Nullable
    public T call() throws Exception {
        return (T)((Callable)((Object)this.source)).call();
    }

    @Override
    public String toString() {
        return this.stacktrace.stackFirst();
    }
}

