/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.FluxPublishMulticast;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import java.util.Objects;
import java.util.function.Function;

final class MonoPublishMulticast<T, R>
extends MonoOperator<T, R>
implements Fuseable {
    final Function<? super Mono<T>, ? extends Mono<? extends R>> transform;

    MonoPublishMulticast(Mono<? extends T> source, Function<? super Mono<T>, ? extends Mono<? extends R>> transform) {
        super(source);
        this.transform = Objects.requireNonNull(transform, "transform");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        Mono<R> out;
        FluxPublishMulticast.FluxPublishMulticaster multicast = new FluxPublishMulticast.FluxPublishMulticaster(Integer.MAX_VALUE, Queues.one(), actual.currentContext());
        try {
            out = Objects.requireNonNull(this.transform.apply(MonoPublishMulticast.fromDirect(multicast)), "The transform returned a null Mono");
        }
        catch (Throwable ex) {
            Operators.error(actual, Operators.onOperatorError(ex, actual.currentContext()));
            return;
        }
        if (out instanceof Fuseable) {
            out.subscribe((CoreSubscriber<R>)new FluxPublishMulticast.CancelFuseableMulticaster<R>(actual, multicast));
        } else {
            out.subscribe((CoreSubscriber<R>)new FluxPublishMulticast.CancelMulticaster<R>(actual, multicast));
        }
        this.source.subscribe(multicast);
    }
}

