/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.channel;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelInitializer;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.pool.ChannelPool;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.channel.AbortedException;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperationsHandler;
import io.micrometer.shaded.reactor.ipc.netty.channel.ClientContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.channel.PooledClientContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.channel.ServerContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.channel.SslReadHandler;
import io.micrometer.shaded.reactor.ipc.netty.options.ClientOptions;
import io.micrometer.shaded.reactor.ipc.netty.options.NettyOptions;
import io.micrometer.shaded.reactor.ipc.netty.options.ServerOptions;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.function.Tuple2;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class ContextHandler<CHANNEL extends Channel>
extends ChannelInitializer<CHANNEL>
implements Disposable,
Consumer<Channel> {
    final MonoSink<NettyContext> sink;
    final NettyOptions<?, ?> options;
    final LoggingHandler loggingHandler;
    final SocketAddress providedAddress;
    final ChannelOperations.OnNew<CHANNEL> channelOpFactory;
    BiConsumer<ChannelPipeline, ContextHandler<Channel>> pipelineConfigurator;
    boolean fired;
    boolean autoCreateOperations;
    static final Logger log = Loggers.getLogger(ContextHandler.class);

    public static <CHANNEL extends Channel> ContextHandler<CHANNEL> newClientContext(MonoSink<NettyContext> sink, ClientOptions options, LoggingHandler loggingHandler, boolean secure, SocketAddress providedAddress, ChannelOperations.OnNew<CHANNEL> channelOpFactory) {
        return ContextHandler.newClientContext(sink, options, loggingHandler, secure, providedAddress, null, channelOpFactory);
    }

    public static <CHANNEL extends Channel> ContextHandler<CHANNEL> newClientContext(MonoSink<NettyContext> sink, ClientOptions options, LoggingHandler loggingHandler, boolean secure, SocketAddress providedAddress, ChannelPool pool, ChannelOperations.OnNew<CHANNEL> channelOpFactory) {
        if (pool != null) {
            return new PooledClientContextHandler<CHANNEL>(channelOpFactory, options, sink, loggingHandler, secure, providedAddress, pool);
        }
        return new ClientContextHandler<CHANNEL>(channelOpFactory, options, sink, loggingHandler, secure, providedAddress);
    }

    public static ContextHandler<Channel> newServerContext(MonoSink<NettyContext> sink, ServerOptions options, LoggingHandler loggingHandler, ChannelOperations.OnNew<Channel> channelOpFactory) {
        return new ServerContextHandler(channelOpFactory, options, sink, loggingHandler, options.getAddress());
    }

    protected ContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, NettyOptions<?, ?> options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, SocketAddress providedAddress) {
        this.channelOpFactory = Objects.requireNonNull(channelOpFactory, "channelOpFactory");
        this.options = options;
        this.sink = sink;
        this.loggingHandler = loggingHandler;
        this.autoCreateOperations = true;
        this.providedAddress = providedAddress;
    }

    public final ContextHandler<CHANNEL> onPipeline(BiConsumer<ChannelPipeline, ContextHandler<Channel>> pipelineConfigurator) {
        this.pipelineConfigurator = Objects.requireNonNull(pipelineConfigurator, "pipelineConfigurator");
        return this;
    }

    public final ContextHandler<CHANNEL> autoCreateOperations(boolean autoCreateOperations) {
        this.autoCreateOperations = autoCreateOperations;
        return this;
    }

    public final ChannelOperations<?, ?> createOperations(Channel channel, Object msg) {
        if (this.autoCreateOperations || msg != null) {
            ChannelOperations<?, ?> op = this.channelOpFactory.create(channel, this, msg);
            if (op != null) {
                ChannelOperations<?, ?> old = ChannelOperations.tryGetAndSet(channel, op);
                if (old != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(channel.toString() + "Mixed pooled connection operations between " + op + " - and a previous one " + old);
                    }
                    return null;
                }
                if (this.options.afterNettyContextInit() != null) {
                    try {
                        this.options.afterNettyContextInit().accept(op.context());
                    }
                    catch (Throwable t) {
                        log.error("Could not apply afterNettyContextInit callback {}", t.toString());
                    }
                }
                channel.pipeline().get(ChannelOperationsHandler.class).lastContext = this;
                channel.eventLoop().execute(op::onHandlerStart);
            }
            return op;
        }
        return null;
    }

    public abstract void fireContextActive(NettyContext var1);

    public void fireContextError(Throwable t) {
        if (!this.fired) {
            this.fired = true;
            this.sink.error(t);
        } else if (AbortedException.isConnectionReset(t)) {
            if (log.isDebugEnabled()) {
                log.error("Connection closed remotely", t);
            }
        } else {
            log.error("Error cannot be forwarded to user-facing Mono", t);
        }
    }

    public abstract void setFuture(Future<?> var1);

    protected void doStarted(Channel channel) {
    }

    @Override
    protected void initChannel(CHANNEL ch) throws Exception {
        this.accept((Channel)ch);
    }

    protected abstract void doPipeline(Channel var1);

    @Override
    public void accept(Channel channel) {
        this.doPipeline(channel);
        if (this.options.onChannelInit() != null && this.options.onChannelInit().test(channel)) {
            if (log.isDebugEnabled()) {
                log.debug("DROPPED by onChannelInit predicate {}", channel);
            }
            this.doDropped(channel);
            return;
        }
        try {
            if (this.pipelineConfigurator != null) {
                this.pipelineConfigurator.accept(channel.pipeline(), this);
            }
            channel.pipeline().addLast("io.micrometer.shaded.reactor.right.reactiveBridge", (ChannelHandler)new ChannelOperationsHandler(this));
        }
        catch (Exception t) {
            if (log.isErrorEnabled()) {
                log.error("Error while binding a channelOperation with: " + channel.toString() + " on " + channel.pipeline(), t);
            }
        }
        finally {
            if (null != this.options.afterChannelInit()) {
                this.options.afterChannelInit().accept(channel);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("After pipeline {}", channel.pipeline().toString());
        }
    }

    protected void doDropped(Channel channel) {
    }

    protected void terminateChannel(Channel channel) {
        this.dispose();
    }

    protected Tuple2<String, Integer> getSNI() {
        return null;
    }

    protected abstract Publisher<Void> onCloseOrRelease(Channel var1);

    static void addSslAndLogHandlers(NettyOptions<?, ?> options, ContextHandler<?> sink, LoggingHandler loggingHandler, boolean secure, Tuple2<String, Integer> sniInfo, ChannelPipeline pipeline) {
        SslHandler sslHandler;
        SslHandler sslHandler2 = sslHandler = secure ? options.getSslHandler(pipeline.channel().alloc(), sniInfo) : null;
        if (sslHandler != null) {
            if (log.isDebugEnabled() && sniInfo != null) {
                log.debug("SSL enabled using engine {} and SNI {}", sslHandler.engine().getClass().getSimpleName(), sniInfo);
            } else if (log.isDebugEnabled()) {
                log.debug("SSL enabled using engine {}", sslHandler.engine().getClass().getSimpleName());
            }
            if (log.isTraceEnabled()) {
                pipeline.addFirst("io.micrometer.shaded.reactor.left.sslLoggingHandler", (ChannelHandler)new LoggingHandler(SslReadHandler.class));
                pipeline.addAfter("io.micrometer.shaded.reactor.left.sslLoggingHandler", "io.micrometer.shaded.reactor.left.sslHandler", sslHandler);
            } else {
                pipeline.addFirst("io.micrometer.shaded.reactor.left.sslHandler", (ChannelHandler)sslHandler);
            }
            if (log.isDebugEnabled()) {
                pipeline.addAfter("io.micrometer.shaded.reactor.left.sslHandler", "io.micrometer.shaded.reactor.left.loggingHandler", loggingHandler);
                pipeline.addAfter("io.micrometer.shaded.reactor.left.loggingHandler", "io.micrometer.shaded.reactor.left.sslReader", new SslReadHandler(sink));
            } else {
                pipeline.addAfter("io.micrometer.shaded.reactor.left.sslHandler", "io.micrometer.shaded.reactor.left.sslReader", new SslReadHandler(sink));
            }
        } else if (log.isDebugEnabled()) {
            pipeline.addFirst("io.micrometer.shaded.reactor.left.loggingHandler", (ChannelHandler)loggingHandler);
        }
    }
}

