/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.util.NetUtil;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.ipc.netty.NettyConnector;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyInbound;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.options.ServerOptions;
import io.micrometer.shaded.reactor.ipc.netty.tcp.TcpResources;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TcpServer
implements NettyConnector<NettyInbound, NettyOutbound> {
    private static final int DEFAULT_PORT_FOR_CREATE = 0;
    final ServerOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(TcpServer.class);
    static final Logger log = Loggers.getLogger(TcpServer.class);

    public static TcpServer create() {
        return TcpServer.builder().listenAddress(new InetSocketAddress(NetUtil.LOCALHOST, 0)).build();
    }

    public static TcpServer create(Consumer<? super ServerOptions.Builder<?>> options) {
        return TcpServer.builder().options(options).build();
    }

    public static TcpServer create(int port) {
        return TcpServer.builder().listenAddress(new InetSocketAddress(port)).build();
    }

    public static TcpServer create(String bindAddress) {
        return TcpServer.create(bindAddress, 0);
    }

    public static TcpServer create(String bindAddress, int port) {
        return TcpServer.builder().bindAddress(bindAddress).port(port).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected TcpServer(Builder builder) {
        ServerOptions.Builder serverOptionsBuilder = ServerOptions.builder();
        if (Objects.isNull(builder.options)) {
            if (Objects.isNull(builder.bindAddress)) {
                serverOptionsBuilder.listenAddress((SocketAddress)builder.listenAddress.get());
            } else {
                ((ServerOptions.Builder)serverOptionsBuilder.host(builder.bindAddress)).port(builder.port);
            }
        } else {
            builder.options.accept(serverOptionsBuilder);
        }
        if (!serverOptionsBuilder.isLoopAvailable()) {
            serverOptionsBuilder.loopResources(TcpResources.get());
        }
        this.options = serverOptionsBuilder.build();
    }

    protected TcpServer(ServerOptions options) {
        this.options = Objects.requireNonNull(options, "options");
    }

    @Override
    public final Mono<? extends NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return Mono.create((MonoSink<T> sink) -> {
            ServerBootstrap b = this.options.get();
            SocketAddress local = this.options.getAddress();
            b.localAddress(local);
            ContextHandler<Channel> contextHandler = this.doHandler(handler, (MonoSink<NettyContext>)sink);
            b.childHandler(contextHandler);
            if (log.isDebugEnabled()) {
                b.handler(this.loggingHandler());
            }
            contextHandler.setFuture(b.bind());
        });
    }

    public ServerOptions options() {
        return this.options.duplicate();
    }

    public String toString() {
        return "TcpServer: " + this.options.asSimpleString();
    }

    protected LoggingHandler loggingHandler() {
        return loggingHandler;
    }

    protected ContextHandler<Channel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink) {
        return ContextHandler.newServerContext(sink, this.options, this.loggingHandler(), (ch, c, msg) -> ChannelOperations.bind(ch, handler, c));
    }

    public static final class Builder {
        private String bindAddress = null;
        private int port = 80;
        private Supplier<InetSocketAddress> listenAddress = () -> new InetSocketAddress(NetUtil.LOCALHOST, this.port);
        private Consumer<? super ServerOptions.Builder<?>> options;

        private Builder() {
        }

        public final Builder bindAddress(String bindAddress) {
            this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
            return this;
        }

        public final Builder listenAddress(InetSocketAddress listenAddress) {
            Objects.requireNonNull(listenAddress, "listenAddress");
            this.listenAddress = () -> listenAddress;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder options(Consumer<? super ServerOptions.Builder<?>> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public TcpServer build() {
            return new TcpServer(this);
        }
    }
}

