/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import com.linecorp.armeria.client.encoding.GzipStreamDecoderFactory;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import zipkin2.server.internal.ZipkinHttpCollector;

final class UnzippingBytesRequestConverter
implements RequestConverterFunction {
    static final GzipStreamDecoderFactory GZIP_DECODER_FACTORY = new GzipStreamDecoderFactory();

    UnzippingBytesRequestConverter() {
    }

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request, Class<?> expectedResultType) {
        ZipkinHttpCollector.metrics.incrementMessages();
        HttpData content = request.content();
        if (content.isEmpty()) {
            throw new IllegalArgumentException("Empty POST body");
        }
        String encoding = (String)request.headers().get((Object)HttpHeaderNames.CONTENT_ENCODING);
        if (encoding != null && encoding.contains("gzip") && (content = GZIP_DECODER_FACTORY.newDecoder().decode(content)).isEmpty()) {
            throw new IllegalArgumentException("Cannot gunzip spans");
        }
        byte[] result = content.array();
        ZipkinHttpCollector.metrics.incrementBytes(result.length);
        return result;
    }
}

