/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAdder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final ProgramClass targetClass;
    private final MemberVisitor extraMemberVisitor;
    private final ConstantAdder constantAdder;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;

    public MemberAdder(ProgramClass targetClass) {
        this(targetClass, null);
    }

    public MemberAdder(ProgramClass targetClass, MemberVisitor extraMemberVisitor) {
        this.targetClass = targetClass;
        this.extraMemberVisitor = extraMemberVisitor;
        this.constantAdder = new ConstantAdder(targetClass);
        this.classEditor = new ClassEditor(targetClass);
        this.constantPoolEditor = new ConstantPoolEditor(targetClass);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        int accessFlags = programField.getAccessFlags();
        ProgramField newProgramField = new ProgramField(accessFlags, this.constantAdder.addConstant((Clazz)programClass, programField.u2nameIndex), this.constantAdder.addConstant((Clazz)programClass, programField.u2descriptorIndex), 0, programField.u2attributesCount > 0 ? new Attribute[programField.u2attributesCount] : EMPTY_ATTRIBUTES, programField.referencedClass);
        newProgramField.setVisitorInfo(programField);
        programField.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramField, false));
        this.classEditor.addField(newProgramField);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramField(this.targetClass, newProgramField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName(programClass);
        String descriptor = programMethod.getDescriptor(programClass);
        int accessFlags = programMethod.getAccessFlags();
        ProgramMethod targetMethod = (ProgramMethod)this.targetClass.findMethod(name, descriptor);
        if (targetMethod != null) {
            if ((accessFlags & 0x400) != 0) {
                return;
            }
            int targetAccessFlags = targetMethod.getAccessFlags();
            if ((targetAccessFlags & 0x400) != 0) {
                targetMethod.u2accessFlags = accessFlags & 0xFFFFFFEF;
                programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, targetMethod, true));
                return;
            }
        }
        ProgramMethod newProgramMethod = new ProgramMethod(accessFlags & 0xFFFFFFEF, this.constantAdder.addConstant((Clazz)programClass, programMethod.u2nameIndex), this.constantAdder.addConstant((Clazz)programClass, programMethod.u2descriptorIndex), 0, programMethod.u2attributesCount > 0 ? new Attribute[programMethod.u2attributesCount] : EMPTY_ATTRIBUTES, programMethod.referencedClasses != null ? (Clazz[])programMethod.referencedClasses.clone() : null);
        newProgramMethod.setVisitorInfo(programMethod);
        programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramMethod, false));
        this.classEditor.addMethod(newProgramMethod);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramMethod(this.targetClass, newProgramMethod);
        }
    }

    private String newUniqueMemberName(String name, String descriptor) {
        return name.equals("<init>") ? "<init>" : name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
    }
}

