/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodFilter;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.StaticInitializerContainingClassFilter;

public class SideEffectInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    static final boolean OPTIMIZE_CONSERVATIVELY = System.getProperty("optimize.conservatively") != null;
    private final boolean includeReturnInstructions;
    private final boolean includeLocalFieldAccess;
    private Clazz referencingClass;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean includeReturnInstructions, boolean includeLocalFieldAccess) {
        this.includeReturnInstructions = includeReturnInstructions;
        this.includeLocalFieldAccess = includeLocalFieldAccess;
    }

    public boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(clazz, method, codeAttribute, offset, this);
        return this.hasSideEffects;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        switch (opcode) {
            case -68: 
            case -67: 
            case -66: 
            case -59: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                this.hasSideEffects = OPTIMIZE_CONSERVATIVELY;
                break;
            }
            case -65: 
            case -62: 
            case -61: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.hasSideEffects = true;
                break;
            }
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        switch (opcode) {
            case -87: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        switch (opcode) {
            case -78: 
            case -77: 
            case -73: 
            case -72: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -76: 
            case -75: 
            case -74: 
            case -71: 
            case -70: {
                if (OPTIMIZE_CONSERVATIVELY) {
                    this.hasSideEffects = true;
                    break;
                }
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -67: 
            case -64: 
            case -59: {
                this.hasSideEffects = OPTIMIZE_CONSERVATIVELY;
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        switch (opcode) {
            case -88: 
            case -55: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.hasSideEffects = true;
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        refConstant.referencedMemberAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.hasSideEffects = (this.includeLocalFieldAccess || !programClass.equals(this.referencingClass)) && (ReadWriteFieldMarker.isRead(programField) && ReadWriteFieldMarker.isWritten(programField) || (programField.getAccessFlags() & 0x40) != 0 || !programClass.equals(this.referencingClass) && !this.initializedSuperClasses(this.referencingClass).containsAll(this.initializedSuperClasses(programClass)));
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.hasSideEffects = !NoSideEffectMethodMarker.hasNoSideEffects(programMethod) && (SideEffectMethodMarker.hasSideEffects(programMethod) || !programClass.equals(this.referencingClass) && !this.initializedSuperClasses(this.referencingClass).containsAll(this.initializedSuperClasses(programClass)));
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.hasSideEffects = true;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.hasSideEffects = !NoSideEffectMethodMarker.hasNoSideEffects(libraryMethod);
    }

    private Set initializedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new StaticInitializerContainingClassFilter(new NamedMethodVisitor("<clinit>", "()V", new SideEffectMethodFilter(new MemberToClassVisitor(new ClassCollector(set))))));
        return set;
    }
}

