/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueStatusEncoding;

public class PersistentQueueBindingEncoding
implements EncodingSupport,
QueueBindingInfo {
    public long id;
    public SimpleString name;
    public SimpleString address;
    public SimpleString filterString;
    public boolean autoCreated;
    public SimpleString user;
    public List<QueueStatusEncoding> queueStatusEncodings;
    public int maxConsumers;
    public boolean purgeOnNoConsumers;
    public byte routingType;

    public PersistentQueueBindingEncoding() {
    }

    public String toString() {
        return "PersistentQueueBindingEncoding [id=" + this.id + ", name=" + this.name + ", address=" + this.address + ", filterString=" + this.filterString + ", user=" + this.user + ", autoCreated=" + this.autoCreated + ", maxConsumers=" + this.maxConsumers + ", purgeOnNoConsumers=" + this.purgeOnNoConsumers + ", routingType=" + this.routingType + "]";
    }

    public PersistentQueueBindingEncoding(SimpleString name, SimpleString address, SimpleString filterString, SimpleString user, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, byte routingType) {
        this.name = name;
        this.address = address;
        this.filterString = filterString;
        this.user = user;
        this.autoCreated = autoCreated;
        this.maxConsumers = maxConsumers;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.routingType = routingType;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void replaceQueueName(SimpleString newName) {
        this.name = newName;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filterString;
    }

    @Override
    public SimpleString getQueueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public void addQueueStatusEncoding(QueueStatusEncoding status) {
        if (this.queueStatusEncodings == null) {
            this.queueStatusEncodings = new LinkedList<QueueStatusEncoding>();
        }
        this.queueStatusEncodings.add(status);
    }

    @Override
    public List<QueueStatusEncoding> getQueueStatusEncodings() {
        return this.queueStatusEncodings;
    }

    @Override
    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    @Override
    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    @Override
    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    @Override
    public byte getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setRoutingType(byte routingType) {
        this.routingType = routingType;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readSimpleString();
        this.address = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        String metadata = buffer.readNullableSimpleString().toString();
        if (metadata != null) {
            String[] elements;
            for (String element : elements = metadata.split(";")) {
                String[] keyValuePair = element.split("=");
                if (keyValuePair.length != 2 || !keyValuePair[0].equals("user")) continue;
                this.user = SimpleString.toSimpleString((String)keyValuePair[1]);
            }
        }
        this.autoCreated = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            this.maxConsumers = buffer.readInt();
            this.purgeOnNoConsumers = buffer.readBoolean();
            this.routingType = buffer.readByte();
        } else {
            this.maxConsumers = ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers();
            this.purgeOnNoConsumers = ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
            this.routingType = ActiveMQDefaultConfiguration.getDefaultRoutingType().getType();
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.name);
        buffer.writeSimpleString(this.address);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.createMetadata());
        buffer.writeBoolean(this.autoCreated);
        buffer.writeInt(this.maxConsumers);
        buffer.writeBoolean(this.purgeOnNoConsumers);
        buffer.writeByte(this.routingType);
    }

    public int getEncodeSize() {
        return SimpleString.sizeofString((SimpleString)this.name) + SimpleString.sizeofString((SimpleString)this.address) + SimpleString.sizeofNullableString((SimpleString)this.filterString) + 1 + SimpleString.sizeofNullableString((SimpleString)this.createMetadata()) + 4 + 1 + 1;
    }

    private SimpleString createMetadata() {
        StringBuilder metadata = new StringBuilder();
        metadata.append("user=").append((CharSequence)this.user).append(";");
        return SimpleString.toSimpleString((String)metadata.toString());
    }
}

