/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TopicTest {
    @Test
    public void shouldAcceptValidTopicNames() {
        String[] validTopicNames;
        String maxLengthString = TestUtils.randomString(249);
        for (String topicName : validTopicNames = new String[]{"valid", "TOPIC", "nAmEs", "ar6", "VaL1d", "_0-9_.", "...", maxLengthString}) {
            Topic.validate((String)topicName);
        }
    }

    @Test
    public void shouldThrowOnInvalidTopicNames() {
        String[] invalidTopicNames;
        char[] longString = new char[250];
        Arrays.fill(longString, 'a');
        for (String topicName : invalidTopicNames = new String[]{"", "foo bar", "..", "foo:bar", "foo=bar", ".", new String(longString)}) {
            try {
                Topic.validate((String)topicName);
                Assert.fail((String)("No exception was thrown for topic with invalid name: " + topicName));
            }
            catch (InvalidTopicException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldRecognizeInvalidCharactersInTopicNames() {
        char[] invalidChars;
        for (char c : invalidChars = new char[]{'/', '\\', ',', '\u0000', ':', '\"', '\'', ';', '*', '?', ' ', '\t', '\r', '\n', '='}) {
            String topicName = "Is " + c + "illegal";
            Assert.assertFalse((boolean)Topic.containsValidPattern((String)topicName));
        }
    }

    @Test
    public void testTopicHasCollisionChars() {
        List<String> falseTopics = Arrays.asList("start", "end", "middle", "many");
        List<String> trueTopics = Arrays.asList(".start", "end.", "mid.dle", ".ma.ny.", "_start", "end_", "mid_dle", "_ma_ny.");
        for (String topic : falseTopics) {
            Assert.assertFalse((boolean)Topic.hasCollisionChars((String)topic));
        }
        for (String topic : trueTopics) {
            Assert.assertTrue((boolean)Topic.hasCollisionChars((String)topic));
        }
    }

    @Test
    public void testTopicHasCollision() {
        int i;
        List<String> periodFirstMiddleLastNone = Arrays.asList(".topic", "to.pic", "topic.", "topic");
        List<String> underscoreFirstMiddleLastNone = Arrays.asList("_topic", "to_pic", "topic_", "topic");
        for (String topic : periodFirstMiddleLastNone) {
            Assert.assertTrue((boolean)Topic.hasCollision((String)topic, (String)topic));
        }
        for (String topic : underscoreFirstMiddleLastNone) {
            Assert.assertTrue((boolean)Topic.hasCollision((String)topic, (String)topic));
        }
        for (i = 0; i < periodFirstMiddleLastNone.size(); ++i) {
            Assert.assertTrue((boolean)Topic.hasCollision((String)periodFirstMiddleLastNone.get(i), (String)underscoreFirstMiddleLastNone.get(i)));
        }
        Collections.reverse(underscoreFirstMiddleLastNone);
        for (i = 0; i < periodFirstMiddleLastNone.size(); ++i) {
            Assert.assertFalse((boolean)Topic.hasCollision((String)periodFirstMiddleLastNone.get(i), (String)underscoreFirstMiddleLastNone.get(i)));
        }
    }
}

