/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$;
import kafka.admin.ReplicaDistributions;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public abstract class RackAwareTest$class {
    public static void checkReplicaDistribution(RackAwareTest $this, Map assignment, Map brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        assignment.withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Seq<Object>> check$ifrefutable$1) {
                Tuple2<Object, Seq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Seq<Object>> x$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x$1;
                if (tuple2 != null) {
                    Seq brokerList = (Seq)tuple2._2();
                    Assert.assertEquals((String)"More than one replica is assigned to same broker for the same partition", (long)brokerList.toSet().size(), (long)brokerList.size());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        ReplicaDistributions distribution = $this.getReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)brokerRackMapping);
        if (verifyRackAware) {
            Map<Object, Seq<String>> partitionRackMap = distribution.partitionRacks();
            Assert.assertEquals((String)"More than one replica of the same partition is assigned to the same rack", (Object)List$.MODULE$.fill(numPartitions, (Function0)new Serializable($this, replicationFactor){
                public static final long serialVersionUID = 0L;
                private final int replicationFactor$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.replicationFactor$1;
                }
                {
                    this.replicationFactor$1 = replicationFactor$1;
                }
            }), (Object)partitionRackMap.values().toList().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(Seq<String> x$2) {
                    return ((SeqLike)x$2.distinct()).size();
                }
            }, List$.MODULE$.canBuildFrom()));
        }
        if (verifyLeaderDistribution) {
            Map<Object, Object> leaderCount = distribution.brokerLeaderCount();
            int leaderCountPerBroker = numPartitions / numBrokers;
            Assert.assertEquals((String)"Preferred leader count is not even for brokers", (Object)List$.MODULE$.fill(numBrokers, (Function0)new Serializable($this, leaderCountPerBroker){
                public static final long serialVersionUID = 0L;
                private final int leaderCountPerBroker$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.leaderCountPerBroker$1;
                }
                {
                    this.leaderCountPerBroker$1 = leaderCountPerBroker$1;
                }
            }), (Object)leaderCount.values().toList());
        }
        if (verifyReplicasDistribution) {
            Map<Object, Object> replicasCount = distribution.brokerReplicasCount();
            int numReplicasPerBroker = numPartitions * replicationFactor / numBrokers;
            Assert.assertEquals((String)"Replica count is not even for broker", (Object)List$.MODULE$.fill(numBrokers, (Function0)new Serializable($this, numReplicasPerBroker){
                public static final long serialVersionUID = 0L;
                private final int numReplicasPerBroker$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.numReplicasPerBroker$1;
                }
                {
                    this.numReplicasPerBroker$1 = numReplicasPerBroker$1;
                }
            }), (Object)replicasCount.values().toList());
        }
    }

    public static boolean checkReplicaDistribution$default$6(RackAwareTest $this) {
        return true;
    }

    public static boolean checkReplicaDistribution$default$7(RackAwareTest $this) {
        return true;
    }

    public static boolean checkReplicaDistribution$default$8(RackAwareTest $this) {
        return true;
    }

    public static ReplicaDistributions getReplicaDistribution(RackAwareTest $this, Map assignment, Map brokerRackMapping) {
        scala.collection.mutable.Map leaderCount = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map partitionCount = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map partitionRackMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        assignment.foreach((Function1)new Serializable($this, leaderCount, partitionCount, partitionRackMap, brokerRackMapping){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map leaderCount$1;
            public final scala.collection.mutable.Map partitionCount$1;
            public final scala.collection.mutable.Map partitionRackMap$1;
            public final Map brokerRackMapping$1;

            public final void apply(Tuple2<Object, Seq<Object>> x0$1) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Seq replicaList = (Seq)tuple2._2();
                    int leader2 = BoxesRunTime.unboxToInt((Object)replicaList.head());
                    this.leaderCount$1.update((Object)BoxesRunTime.boxToInteger((int)leader2), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.leaderCount$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)leader2), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })) + 1)));
                    replicaList.foreach((Function1)new Serializable(this, partitionId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RackAwareTest$.anonfun.getReplicaDistribution.1 $outer;
                        private final int partitionId$1;

                        public final void apply(int brokerId) {
                            this.apply$mcVI$sp(brokerId);
                        }

                        public void apply$mcVI$sp(int brokerId) {
                            String rack;
                            this.$outer.partitionCount$1.update((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.partitionCount$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return 0;
                                }
                            })) + 1)));
                            String string = rack = (String)this.$outer.brokerRackMapping$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0)new Serializable(this, brokerId){
                                public static final long serialVersionUID = 0L;
                                private final int brokerId$1;

                                public final Nothing$ apply() {
                                    return package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No mapping found for ", " in `brokerRackMapping`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId$1)})));
                                }
                                {
                                    this.brokerId$1 = brokerId$1;
                                }
                            });
                            this.$outer.partitionRackMap$1.update((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1), (Object)((List)this.$outer.partitionRackMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final List<Nothing$> apply() {
                                    return Nil$.MODULE$;
                                }
                            })).$colon$colon((Object)string));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partitionId$1 = partitionId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.leaderCount$1 = leaderCount$1;
                this.partitionCount$1 = partitionCount$1;
                this.partitionRackMap$1 = partitionRackMap$1;
                this.brokerRackMapping$1 = brokerRackMapping$1;
            }
        });
        return new ReplicaDistributions((Map<Object, Seq<String>>)partitionRackMap, (Map<Object, Object>)leaderCount, (Map<Object, Object>)partitionCount);
    }

    public static Seq toBrokerMetadata(RackAwareTest $this, Map rackMap, Seq brokersWithoutRack) {
        return (Seq)((TraversableLike)rackMap.toSeq().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int brokerId = tuple2._1$mcI$sp();
                    String rack = (String)tuple2._2();
                    BrokerMetadata brokerMetadata = new BrokerMetadata(brokerId, (Option)new Some((Object)rack));
                    return brokerMetadata;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((SeqLike)brokersWithoutRack.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(int brokerId) {
                return new BrokerMetadata(brokerId, (Option)None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$4) {
                return x$4.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public static Seq toBrokerMetadata$default$2(RackAwareTest $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static void $init$(RackAwareTest $this) {
    }
}

