/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u000f\t\u0011\"I]8lKJ,e\u000e\u001a)pS:$H+Z:u\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002#Q,7\u000f\u001e%bg\"\fe\u000eZ#rk\u0006d7\u000fF\u0001\u0017!\tIq#\u0003\u0002\u0019\u0015\t!QK\\5uQ\t\u0019\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\t!F\u0001\u001ai\u0016\u001cHO\u0012:p[*\u001bxN\u001c$viV\u0014XMV3sg&|g\u000e\u000b\u0002#5!)a\u0005\u0001C\u0001+\u0005qA/Z:u\rJ|WNS:p]Z\u0013\u0004FA\u0013\u001b\u0011\u0015I\u0003\u0001\"\u0001\u0016\u00039!Xm\u001d;Ge>l'j]8o-FB#\u0001\u000b\u000e\t\u000b1\u0002A\u0011A\u000b\u0002\u001dQ,7\u000f\u001e$s_6T5o\u001c8Wg!\u00121F\u0007\u0005\u0006_\u0001!\t!F\u0001\u001bi\u0016\u001cHO\u0012:p[*\u001bxN\u001c,5/&$\bNT;mYJ\u000b7m\u001b\u0015\u0003]iAQA\r\u0001\u0005\u0002U\t\u0001\u0004^3ti\u001a\u0013x.\u001c&t_:4FgV5uQ:{'+Y2lQ\t\t$\u0004C\u00036\u0001\u0011\u0005Q#A\ruKN$(I]8lKJ,e\u000e\u001a9pS:$hI]8n+JL\u0007F\u0001\u001b\u001b\u0011\u0015A\u0004\u0001\"\u0001\u0016\u0003M!Xm\u001d;F]\u0012\u0004x.\u001b8u\rJ|W.\u0016:jQ\t9$\u0004")
public class BrokerEndPointTest {
    @Test
    public void testHashAndEquals() {
        Broker broker1 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker2 = TestUtils$.MODULE$.createBroker(1, "myhost", 9092, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker3 = TestUtils$.MODULE$.createBroker(2, "myhost", 1111, TestUtils$.MODULE$.createBroker$default$4());
        Broker broker4 = TestUtils$.MODULE$.createBroker(1, "other", 1111, TestUtils$.MODULE$.createBroker$default$4());
        Assert.assertEquals((Object)broker1, (Object)broker2);
        Assert.assertNotEquals((Object)broker1, (Object)broker3);
        Assert.assertNotEquals((Object)broker1, (Object)broker4);
        Assert.assertEquals((long)broker1.hashCode(), (long)broker2.hashCode());
        Assert.assertNotEquals((long)broker1.hashCode(), (long)broker3.hashCode());
        Assert.assertNotEquals((long)broker1.hashCode(), (long)broker4.hashCode());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker1), (Object)BoxesRunTime.boxToInteger((int)1))}))).get((Object)broker1));
    }

    @Test
    public void testFromJsonFutureVersion() {
        String brokerInfoStr = "{\n      \"foo\":\"bar\",\n      \"version\":100,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"SSL://localhost:9093\"]\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assert.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9093L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV2() {
        String brokerInfoStr = "{\n      \"version\":2,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"1416974968782\",\n      \"endpoints\":[\"PLAINTEXT://localhost:9092\"]\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assert.assertEquals((Object)"localhost", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV1() {
        String brokerInfoStr = "{\"jmx_port\":-1,\"timestamp\":\"1420485325400\",\"host\":\"172.16.8.243\",\"version\":1,\"port\":9091}";
        Broker broker = Broker$.MODULE$.createBroker(1, brokerInfoStr);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        Assert.assertEquals((Object)"172.16.8.243", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9091L, (long)brokerEndPoint.port());
    }

    @Test
    public void testFromJsonV3() {
        String json = "{\n      \"version\":3,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"PLAINTEXT://host1:9092\", \"SSL://host1:9093\"],\n      \"rack\":\"dc1\"\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9093L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)new Some((Object)"dc1"), (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNullRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"},\n      \"rack\":null\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(new ListenerName("CLIENT"));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testFromJsonV4WithNoRack() {
        String json = "{\n      \"version\":4,\n      \"host\":\"localhost\",\n      \"port\":9092,\n      \"jmx_port\":9999,\n      \"timestamp\":\"2233345666\",\n      \"endpoints\":[\"CLIENT://host1:9092\", \"REPLICATION://host1:9093\"],\n      \"listener_security_protocol_map\":{\"CLIENT\":\"SSL\", \"REPLICATION\":\"PLAINTEXT\"}\n    }";
        Broker broker = Broker$.MODULE$.createBroker(1, json);
        Assert.assertEquals((long)1L, (long)broker.id());
        BrokerEndPoint brokerEndPoint = broker.getBrokerEndPoint(new ListenerName("CLIENT"));
        Assert.assertEquals((Object)"host1", (Object)brokerEndPoint.host());
        Assert.assertEquals((long)9092L, (long)brokerEndPoint.port());
        Assert.assertEquals((Object)None$.MODULE$, (Object)broker.rack());
    }

    @Test
    public void testBrokerEndpointFromUri() {
        String connectionString = "localhost:9092";
        BrokerEndPoint endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "local_host:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "[::1]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"::1", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        connectionString = "MyHostname:9092";
        endpoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(1, connectionString);
        Assert.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
    }

    @Test
    public void testEndpointFromUri() {
        String connectionString = "PLAINTEXT://localhost:9092";
        EndPoint endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"localhost", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://localhost:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://local_host:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"local_host", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://local_host:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertNull((Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[::1]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"::1", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://[::1]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:9092", (Object)endpoint.connectionString());
        connectionString = "PLAINTEXT://MyHostname:9092";
        endpoint = EndPoint$.MODULE$.createEndPoint(connectionString, (Option)None$.MODULE$);
        Assert.assertEquals((Object)"MyHostname", (Object)endpoint.host());
        Assert.assertEquals((long)9092L, (long)endpoint.port());
        Assert.assertEquals((Object)"PLAINTEXT://MyHostname:9092", (Object)endpoint.connectionString());
    }
}

