/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.StandardOpenOption;
import kafka.message.BaseMessageSetTestCases;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileRecords;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class BaseMessageSetTestCases$class {
    @Test
    public static void testWrittenEqualsRead(BaseMessageSetTestCases $this) {
        MessageSet messageSet = $this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages()));
        Assert.assertEquals((Object)Predef$.MODULE$.refArrayOps((Object[])$this.messages()).toVector(), (Object)messageSet.toVector().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset m) {
                return m.message();
            }
        }, Vector$.MODULE$.canBuildFrom()));
    }

    @Test
    public static void testIteratorIsConsistent(BaseMessageSetTestCases $this) {
        MessageSet m = $this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages()));
        TestUtils$.MODULE$.checkEquals(m.iterator(), m.iterator());
    }

    @Test
    public static void testSizeInBytes(BaseMessageSetTestCases $this) {
        Assert.assertEquals((String)"Empty message set should have 0 bytes.", (long)0L, (long)$this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))).sizeInBytes());
        Assert.assertEquals((String)"Predicted size should equal actual size.", (long)MessageSet$.MODULE$.messageSetSize((Iterable)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())), (long)$this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())).sizeInBytes());
    }

    @Test
    public static void testWriteTo(BaseMessageSetTestCases $this) {
        $this.checkWriteToWithMessageSet($this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))));
        $this.checkWriteToWithMessageSet($this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])$this.messages())));
    }

    @Test
    public static void testWriteToChannelThatConsumesPartially(BaseMessageSetTestCases $this) {
        int bytesToConsumePerBuffer = 50;
        IndexedSeq messages = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int x$2) {
                return new Message(TestUtils$.MODULE$.randomString(100).getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        MessageSet messageSet = $this.createMessageSet((Seq<Message>)messages);
        int messageSetSize = messageSet.sizeInBytes();
        BaseMessageSetTestCases.StubByteChannel channel = new BaseMessageSetTestCases.StubByteChannel($this, bytesToConsumePerBuffer);
        int remaining = messageSetSize;
        int iterations = 0;
        while (remaining > 0) {
            remaining -= (int)messageSet.asRecords().writeTo((GatheringByteChannel)channel, (long)(messageSetSize - remaining), remaining);
            ++iterations;
        }
        Assert.assertEquals((long)(messageSetSize / bytesToConsumePerBuffer + 1), (long)iterations);
        TestUtils$.MODULE$.checkEquals(new ByteBufferMessageSet(ByteBuffer.wrap((byte[])channel.data().toArray(ClassTag$.MODULE$.Byte()))).iterator(), messageSet.iterator());
    }

    public static void checkWriteToWithMessageSet(BaseMessageSetTestCases $this, MessageSet messageSet) {
        $this.checkWriteWithMessageSet(messageSet, (Function1<GatheringByteChannel, Object>)new Serializable($this, messageSet){
            public static final long serialVersionUID = 0L;
            private final MessageSet messageSet$1;

            public final long apply(GatheringByteChannel x$3) {
                return this.messageSet$1.asRecords().writeTo(x$3, 0L, this.messageSet$1.sizeInBytes());
            }
            {
                this.messageSet$1 = messageSet$1;
            }
        });
    }

    public static void checkWriteWithMessageSet(BaseMessageSetTestCases $this, MessageSet set, Function1 write2) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)new Serializable($this, set, write2){
            public static final long serialVersionUID = 0L;
            private final MessageSet set$1;
            private final Function1 write$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcVI$sp(int _) {
                File file = TestUtils$.MODULE$.tempFile();
                FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                try {
                    long written = BoxesRunTime.unboxToLong((Object)this.write$1.apply((Object)channel));
                    Assert.assertEquals((String)"Expect to write the number of bytes in the set.", (long)this.set$1.sizeInBytes(), (long)written);
                    FileRecords fileRecords = new FileRecords(file, channel, 0, Integer.MAX_VALUE, false);
                    Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.set$1.asRecords().records()).asScala()).toVector(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.records()).asScala()).toVector());
                    TestUtils$.MODULE$.checkEquals(this.set$1.asRecords().records().iterator(), fileRecords.records().iterator());
                }
                catch (Throwable throwable) {
                    void var3_3;
                    var3_3.close();
                    throw throwable;
                }
                channel.close();
            }
            {
                this.set$1 = set$1;
                this.write$1 = write$1;
            }
        });
    }

    public static void $init$(BaseMessageSetTestCases $this) {
        $this.kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq((Message[])((Object[])new Message[]{new Message("abcd".getBytes()), new Message("efgh".getBytes()), new Message("ijkl".getBytes())}));
    }
}

