/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.util.Properties;
import javax.management.ObjectName;
import kafka.admin.AdminUtils$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.serializer.StringDecoder$;
import kafka.server.BrokerTopicStats$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u00111\"T3ue&\u001c7\u000fV3ti*\u00111\u0001B\u0001\b[\u0016$(/[2t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!BA\u0006\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00055Q!AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u0005Aa.^7O_\u0012,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u00139,XNT8eKN\u0004\u0003bB\u0013\u0001\u0005\u0004%\taG\u0001\t]Vl\u0007+\u0019:ug\"1q\u0005\u0001Q\u0001\nq\t\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019!\u0004\u0001)A\u0005W\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\u0006m\u0001!\taN\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\bE\u0002:\u0003\u0012s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011A\u0002\u001fs_>$h(C\u0001 \u0013\t\u0001e$A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001I\b\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\taa]3sm\u0016\u0014\u0018BA%G\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f-\u0003!\u0019!C\u00017\u0005Ia.T3tg\u0006<Wm\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\u000f\u0002\u00159lUm]:bO\u0016\u001c\b\u0005C\u0003P\u0001\u0011\u0005\u0001+A\buKN$X*\u001a;sS\u000e\u001cH*Z1l)\u0005\t\u0006CA\u000fS\u0013\t\u0019fD\u0001\u0003V]&$\b\u0006\u0002(V1j\u0003\"!\b,\n\u0005]s\"A\u00033faJ,7-\u0019;fI\u0006\n\u0011,\u0001%UQ&\u001c\b\u0005^3ti\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI5uA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012\u0004\u0013N\u001c\u0011bA\u0019,H/\u001e:fAI,G.Z1tK\u0006\n1,\u0001\u00051]E\u0002d\u0006\r\u00181Q\tqU\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006)!.\u001e8ji*\t!-A\u0002pe\u001eL!\u0001Z0\u0003\tQ+7\u000f\u001e\u0005\u0006M\u0002!\t\u0001U\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#!Z/\t\u000b%\u0004A\u0011\u0001)\u0002iQ,7\u000f\u001e\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN,fN]3hSN$XM]3e\u0003\u001a$XM\u001d#fY\u0016$\u0018N\\4U_BL7\r\u000b\u0002i;\")A\u000e\u0001C\u0001!\u0006\u0019B/Z:u\u00072,8\u000f^3s\u0013\u0012lU\r\u001e:jG\"\u00121.\u0018\u0005\u0006_\u0002!\t\u0001U\u0001\u0019i\u0016\u001cHoV5oI><8o\u0015;zY\u0016$\u0016m\u001a(b[\u0016\u001c\bF\u00018^\u0011\u0015\u0011\b\u0001\"\u0001t\u0003U\u0019'/Z1uK\u0006sGm\u00155vi\u0012|wO\\*uKB$b!\u0015;~\u007f\u0006\r\u0001\"B;r\u0001\u00041\u0018!\u0002;pa&\u001c\u0007CA<{\u001d\ti\u00020\u0003\u0002z=\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tIh\u0004C\u0003\u007fc\u0002\u0007a/A\u0003he>,\b\u000f\u0003\u0004\u0002\u0002E\u0004\rA^\u0001\u000bG>t7/^7fe&#\u0007BBA\u0003c\u0002\u0007a/\u0001\u0006qe>$WoY3s\u0013\u0012DC!]+Y5\"1\u00111\u0002\u0001\u0005\u0002A\u000b\u0001\u0005^3ti\n\u0013xn[3s)>\u0004\u0018nY'fiJL7m\u001d\"zi\u0016\u001c\u0018J\\(vi\"\u001a\u0011\u0011B/\t\r\u0005E\u0001\u0001\"\u0001Q\u0003U!Xm\u001d;D_:$(o\u001c7mKJlU\r\u001e:jGND3!a\u0004^\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t!\"\\3uKJ\u001cu.\u001e8u)\u0011\tY\"!\t\u0011\u0007u\ti\"C\u0002\u0002 y\u0011A\u0001T8oO\"9\u00111EA\u000b\u0001\u00041\u0018AC7fiJL7MT1nK\"9\u0011q\u0005\u0001\u0005\n\u0005%\u0012!\u0005;pa&\u001cW*\u001a;sS\u000e<%o\\;qgR!\u00111FA\u001c!\u0015\ti#a\rw\u001b\t\tyCC\u0002\u00022y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)$a\f\u0003\u0007M+G\u000f\u0003\u0004v\u0003K\u0001\rA\u001e")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$12 = this.numNodes();
        String x$13 = this.zkConnect();
        boolean x$14 = true;
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        Option<SecurityProtocol> x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$18 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$19 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$12, x$13, x$15, x$14, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsLeak() {
        String topic = "test-metrics-leak";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.createAndShutdownStep(topic, "group0", "consumer0", "producer0");
        Assert.assertNotNull((Object)DelayedFetchMetrics$.MODULE$);
        int countOfStaticMetrics = Metrics.defaultRegistry().allMetrics().keySet().size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, topic, countOfStaticMetrics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String topic$1;
            private final int countOfStaticMetrics$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.createAndShutdownStep(this.topic$1, new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToInteger((int)(i % 3))).toString(), new StringBuilder().append((Object)"consumer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString(), new StringBuilder().append((Object)"producer").append((Object)BoxesRunTime.boxToInteger((int)(i % 2))).toString());
                Assert.assertEquals((long)this.countOfStaticMetrics$1, (long)Metrics.defaultRegistry().allMetrics().keySet().size());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.countOfStaticMetrics$1 = countOfStaticMetrics$1;
            }
        });
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        Assert.assertTrue((String)"Topic metrics don't exist", (boolean)this.topicMetricGroups(topic).nonEmpty());
        this.servers().foreach((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final void apply(KafkaServer s) {
                Assert.assertNotNull((Object)s.brokerTopicStats().topicStats(this.topic$2));
            }
            {
                this.topic$2 = topic$2;
            }
        });
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assert.assertEquals((String)"Topic metrics exists after deleteTopic", (Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic));
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$2) {
                String string = x$2.getMBeanName();
                String string2 = "kafka.server:type=KafkaServer,name=ClusterId";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        String $org_scalatest_assert_macro_left = metric.getMBeanName();
        String $org_scalatest_assert_macro_right = expectedMBeanName;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    public void createAndShutdownStep(String topic, String group, String consumerId, String producerId) {
        TestUtils$.MODULE$.sendMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.sendMessages$default$4(), TestUtils$.MODULE$.sendMessages$default$5());
        ConsumerConfig consumerConfig1 = new ConsumerConfig(TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), group, consumerId, TestUtils$.MODULE$.createConsumerProperties$default$4()));
        ZookeeperConsumerConnector zkConsumerConnector1 = new ZookeeperConsumerConnector(consumerConfig1, true);
        Map topicMessageStreams1 = zkConsumerConnector1.createMessageStreams((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))})), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()), (Decoder)new StringDecoder(StringDecoder$.MODULE$.$lessinit$greater$default$1()));
        TestUtils$.MODULE$.getMessages((Map<String, List<KafkaStream<String, String>>>)topicMessageStreams1, this.nMessages());
        zkConsumerConnector1.shutdown();
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesInPerSec(), topic}));
        String bytesOut = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.BytesOutPerSec(), topic}));
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, 1, this.numNodes(), (Seq<KafkaServer>)this.servers(), topicConfig);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1)new Serializable(this, topic, topicPartition){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final TopicPartition topicPartition$1;

            public final void apply(KafkaServer server) {
                Option log2 = server.logManager().logsByTopicPartition().get((Object)new TopicPartition(this.topic$3, 0));
                int brokerId = server.config().brokerId();
                Option logSize = log2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Log x$3) {
                        return x$3.size();
                    }
                });
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected broker ", " to have a Log for ", " with positive size, actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)brokerId), this.topicPartition$1, logSize})), (boolean)BoxesRunTime.unboxToBoolean((Object)logSize.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$4) {
                        return this.apply$mcZJ$sp(x$4);
                    }

                    public boolean apply$mcZJ$sp(long x$4) {
                        return x$4 > 0L;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                })));
            }
            {
                this.topic$3 = topic$3;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        long initialReplicationBytesIn = this.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = this.meterCount(replicationBytesOut);
        long initialBytesIn = this.meterCount(bytesIn);
        long initialBytesOut = this.meterCount(bytesOut);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        Assert.assertTrue((this.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assert.assertTrue((this.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assert.assertEquals((long)initialBytesOut, (long)this.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages() * 2, TestUtils$.MODULE$.consumeTopicRecords$default$4());
        Assert.assertTrue((this.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = Metrics.defaultRegistry().allMetrics();
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$5) {
                String string = x$5.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$6) {
                String string = x$6.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$7) {
                String string = x$7.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$8) {
                String string = x$8.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
        Assert.assertEquals((long)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$9) {
                String string = x$9.getMBeanName();
                String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }), (long)1L);
    }

    private long meterCount(String metricName) {
        return ((Meter)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(MetricName x$10) {
                return x$10.getMBeanName().endsWith(this.metricName$1);
            }
            {
                this.metricName$1 = metricName$1;
            }
        }).values().headOption().getOrElse((Function0)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetricsTest $outer;
            private final String metricName$1;

            public final Nothing$ apply() {
                return this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricName$1})), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metricName$1 = metricName$1;
            }
        })).count();
    }

    private Set<String> topicMetricGroups(String topic) {
        Regex topicMetricRegex = new Regex(new StringBuilder().append((Object)".*BrokerTopicMetrics.*(").append((Object)topic).append((Object)")$").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return (Set)metricGroups.filter((Function1)new Serializable(this, topicMetricRegex){
            public static final long serialVersionUID = 0L;
            private final Regex topicMetricRegex$1;

            public final boolean apply(String x$11) {
                return this.topicMetricRegex$1.pattern().matcher(x$11).matches();
            }
            {
                this.topicMetricRegex$1 = topicMetricRegex$1;
            }
        });
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numParts())).toString());
        this.nMessages = 2;
    }
}

