/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetup$class;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011acU2sC6\u001cVM\u001d<feN#\u0018M\u001d;vaR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aA1qS&\u0011QB\u0003\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u0011\u0011bD\u0005\u0003!)\u0011\u0011bU1tYN+G/\u001e9\t\u000bI\u0001A\u0011A\n\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u0005\u0011\u0001bB\f\u0001\u0005\u0004%\t\u0005G\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0016\u0003e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u00111!\u00138u\u0011\u0019\u0001\u0003\u0001)A\u00053\u0005q\u0001O]8ek\u000e,'oQ8v]R\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%\t\u0005G\u0001\u000eG>t7/^7fe\u000e{WO\u001c;\t\r\u0011\u0002\u0001\u0015!\u0003\u001a\u00039\u0019wN\\:v[\u0016\u00148i\\;oi\u0002BqA\n\u0001C\u0002\u0013\u0005\u0003$A\u0006tKJ4XM]\"pk:$\bB\u0002\u0015\u0001A\u0003%\u0011$\u0001\u0007tKJ4XM]\"pk:$\b\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007BB\u001b\u0001A\u0003%A&A\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001O\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001:!\rQt\bL\u0007\u0002w)\u0011A(P\u0001\b[V$\u0018M\u00197f\u0015\tq4$\u0001\u0006d_2dWm\u0019;j_:L!\u0001Q\u001e\u0003\r\t+hMZ3s\u0011\u0019\u0011\u0005\u0001)A\u0005s\u0005Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA!)A\t\u0001C)\u000b\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0002\rB\u0011qiU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0005CV$\bN\u0003\u0002L\u0019\u0006A1/Z2ve&$\u0018P\u0003\u0002N\u001d\u000611m\\7n_:T!!B(\u000b\u0005A\u000b\u0016AB1qC\u000eDWMC\u0001S\u0003\ry'oZ\u0005\u0003)\"\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000fY\u0003!\u0019!C)/\u0006!2/\u001a:wKJ\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN,\u0012\u0001\u0017\t\u00045e[\u0016B\u0001.\u001c\u0005\u0011\u0019v.\\3\u0011\u0005q{V\"A/\u000b\u0005y\u0003\u0014\u0001B;uS2L!\u0001Y/\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004c\u0001\u0001\u0006I\u0001W\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0011\u001d!\u0007A1A\u0005R]\u000bAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\bB\u00024\u0001A\u0003%\u0001,A\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm\u001d\u0011\t\u000b!\u0004A\u0011I5\u0002G\r|gNZ5hkJ,7+Z2ve&$\u0018PQ3g_J,7+\u001a:wKJ\u001c8\u000b^1siR\t!\u000e\u0005\u0002\u001bW&\u0011An\u0007\u0002\u0005+:LG\u000fC\u0003o\u0001\u0011\u0005\u0011.A\nuKN$\u0018)\u001e;iK:$\u0018nY1uS>t7\u000f\u000b\u0002naB\u0011\u0011\u000f^\u0007\u0002e*\u00111/U\u0001\u0006UVt\u0017\u000e^\u0005\u0003kJ\u0014A\u0001V3ti\")q\u000f\u0001C\u0005q\u0006!Bo\u001c;bY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]N$\"!G=\t\u000bi4\b\u0019A>\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0002}\u007f:\u0011!$`\u0005\u0003}n\ta\u0001\u0015:fI\u00164\u0017bA\u001a\u0002\u0002)\u0011ap\u0007")
public class ScramServerStartupTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final Buffer<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    @TraitSetter
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup$class.startSasl(this, jaasSections);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup$class.maybeCreateEmptyKeytabFiles(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup$class.jaasSections(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public void closeSasl() {
        SaslSetup$class.closeSasl(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup$class.kafkaServerSaslProperties(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup$class.kafkaClientSaslProperties(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism) {
        return SaslSetup$class.jaasClientLoginModule(this, clientSaslMechanism);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup$class.createScramCredentials(this, zkConnect, userName, password);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup$class.kafkaClientSaslProperties$default$2(this);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup$class.jaasSections$default$3(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup$class.jaasSections$default$4(this);
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private Buffer<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        ZkUtils qual$1 = this.zkUtils();
        String x$2 = ZkUtils$.MODULE$.ConfigChangesPath();
        List x$3 = qual$1.makeSurePersistentPathExists$default$2();
        qual$1.makeSurePersistentPathExists(x$2, x$3);
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.jaasSections$default$4()));
    }

    @Test
    public void testAuthentications() {
        int successfulAuths = this.totalAuthentications("successful-authentication-total");
        Assert.assertTrue((String)"No successful authentications", (successfulAuths > 0 ? 1 : 0) != 0);
        int failedAuths = this.totalAuthentications("failed-authentication-total");
        Assert.assertEquals((long)0L, (long)failedAuths);
    }

    private int totalAuthentications(String metricName) {
        Map allMetrics = ((KafkaServer)this.servers().head()).metrics().metrics();
        double totalAuthCount = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(allMetrics.values()).asScala()).filter((Function1)new Serializable(this, metricName){
            public static final long serialVersionUID = 0L;
            private final String metricName$1;

            public final boolean apply(KafkaMetric x$1) {
                String string = x$1.metricName().name();
                String string2 = this.metricName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.metricName$1 = metricName$1;
            }
        })).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double total, KafkaMetric metric) {
                return total + BoxesRunTime.unboxToDouble((Object)metric.metricValue());
            }
        }));
        return (int)totalAuthCount;
    }

    public ScramServerStartupTest() {
        SaslSetup$class.$init$(this);
        this.producerCount = 0;
        this.consumerCount = 0;
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.singletonList("SCRAM-SHA-256")).asScala();
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

