/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.epoch.LeaderEpochCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u0013\tIrJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eDG+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013%q#\u0001\u0004d_:4\u0017nZ\u000b\u00021A\u0011\u0011DG\u0007\u0002\t%\u00111\u0004\u0002\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0004\u001e\u0001\u0001\u0006I\u0001G\u0001\bG>tg-[4!\u0011\u001dy\u0002A1A\u0005\n\u0001\nA\u0001^5nKV\t\u0011\u0005\u0005\u0002#K5\t1E\u0003\u0002%\r\u0005)Q\u000f^5mg&\u0011ae\t\u0002\t\u001b>\u001c7\u000eV5nK\"1\u0001\u0006\u0001Q\u0001\n\u0005\nQ\u0001^5nK\u0002BqA\u000b\u0001C\u0002\u0013%1&A\u0004nKR\u0014\u0018nY:\u0016\u00031\u0002\"!\f\u001c\u000e\u00039R!AK\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\be)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9dFA\u0004NKR\u0014\u0018nY:\t\re\u0002\u0001\u0015!\u0003-\u0003!iW\r\u001e:jGN\u0004\u0003bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0003iB,\u0012!\u0010\t\u0003}}j\u0011aL\u0005\u0003\u0001>\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004C\u0001\u0001\u0006I!P\u0001\u0004iB\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015AG:i_VdGmR3u\u000bB|7\r[:Ge>l'+\u001a9mS\u000e\fG#\u0001$\u0011\u0005-9\u0015B\u0001%\r\u0005\u0011)f.\u001b;)\u0005\rS\u0005CA&O\u001b\u0005a%BA'5\u0003\u0015QWO\\5u\u0013\tyEJ\u0001\u0003UKN$\b\"B)\u0001\t\u0003)\u0015\u0001K:i_VdGMU3ukJtgj\u001c'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:Le\r\u00165s_^t\u0007F\u0001)K\u0011\u0015!\u0006\u0001\"\u0001F\u0003-\u001a\bn\\;mIJ+G/\u001e:o+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:Le\r\u00165s_^t\u0007FA*K\u0001")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableLike)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties props) {
            return KafkaConfig$.MODULE$.fromProps(props);
        }
    }, Seq$.MODULE$.canBuildFrom())).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TopicPartition tp = new TopicPartition("topic", 1);

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    @Test
    public void shouldGetEpochsFromReplica() {
        int offset = 42;
        Integer epochRequested = Predef$.MODULE$.int2Integer(5);
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)epochRequested)}));
        Log mockLog = (Log)EasyMock.createNiceMock(Log.class);
        LeaderEpochCache mockCache = (LeaderEpochCache)EasyMock.createNiceMock(LeaderEpochCache.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)mockCache.endOffsetFor(Predef$.MODULE$.Integer2int(epochRequested)))).andReturn((Object)BoxesRunTime.boxToLong((long)offset));
        EasyMock.expect((Object)mockLog.leaderEpochCache()).andReturn((Object)mockCache).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockCache, mockLog, logManager});
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(this.config().logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        Partition partition = replicaManager.getOrCreatePartition(this.tp());
        Replica leaderReplica = new Replica(this.config().brokerId(), partition.topicPartition(), (Time)this.time(), 0L, (Option)new Some((Object)mockLog));
        partition.addReplicaIfNotExists(leaderReplica);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())));
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NONE, (long)offset), (Object)response.apply((Object)this.tp()));
    }

    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(this.config().logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.getOrCreatePartition(this.tp());
        Integer epochRequested = Predef$.MODULE$.int2Integer(5);
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)epochRequested)}));
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1L), (Object)response.apply((Object)this.tp()));
    }

    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), "").follower(), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(this.config().logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        Integer epochRequested = Predef$.MODULE$.int2Integer(5);
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)epochRequested)}));
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.UNKNOWN_TOPIC_OR_PARTITION, -1L), (Object)response.apply((Object)this.tp()));
    }
}

