/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.webflux;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ProxyExchange<T> {
    public static Set<String> DEFAULT_SENSITIVE = new HashSet<String>(Arrays.asList("cookie", "authorization"));
    private URI uri;
    private WebClient rest;
    private Publisher<Object> body;
    private boolean hasBody = false;
    private ServerWebExchange exchange;
    private BindingContext bindingContext;
    private Set<String> sensitive;
    private HttpHeaders headers = new HttpHeaders();
    private Type responseType;

    public ProxyExchange(WebClient rest, ServerWebExchange exchange, BindingContext bindingContext, Type type) {
        this.exchange = exchange;
        this.bindingContext = bindingContext;
        this.responseType = type;
        this.rest = rest;
    }

    public ProxyExchange<T> body(Object body) {
        this.body = Mono.just((Object)body);
        return this;
    }

    public ProxyExchange<T> body(Publisher<?> body) {
        this.body = body;
        return this;
    }

    public ProxyExchange<T> header(String name, String ... value) {
        this.headers.put(name, Arrays.asList(value));
        return this;
    }

    public ProxyExchange<T> headers(HttpHeaders headers) {
        this.headers.putAll((Map)headers);
        return this;
    }

    public ProxyExchange<T> sensitive(String ... names) {
        if (this.sensitive == null) {
            this.sensitive = new HashSet<String>();
        }
        for (String name : names) {
            this.sensitive.add(name.toLowerCase());
        }
        return this;
    }

    public ProxyExchange<T> uri(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI", e);
        }
        return this;
    }

    public String path() {
        return this.exchange.getRequest().getPath().pathWithinApplication().value();
    }

    public String path(String prefix) {
        String path = this.path();
        if (!path.startsWith(prefix)) {
            throw new IllegalArgumentException("Path does not start with prefix (" + prefix + "): " + path);
        }
        return path.substring(prefix.length());
    }

    public Mono<ResponseEntity<T>> get() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.get((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> get(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.get().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> head() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.head((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> head(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.head().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> options() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.options((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> options(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.options().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> post() {
        RequestEntity requestEntity = this.headers(RequestEntity.post((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> post(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.post().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> delete() {
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.delete((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> delete(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.delete().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> put() {
        RequestEntity requestEntity = this.headers(RequestEntity.put((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> put(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.put().map(converter::apply);
    }

    public Mono<ResponseEntity<T>> patch() {
        RequestEntity requestEntity = this.headers(RequestEntity.patch((URI)this.uri)).body(this.body());
        return this.exchange(requestEntity);
    }

    public <S> Mono<ResponseEntity<S>> patch(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return this.patch().map(converter::apply);
    }

    private Mono<ResponseEntity<T>> exchange(RequestEntity<?> requestEntity) {
        Mono result;
        Type type = this.responseType;
        WebClient.RequestBodySpec builder = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.rest.method(requestEntity.getMethod()).uri(requestEntity.getUrl())).headers(headers -> headers.addAll((MultiValueMap)requestEntity.getHeaders()));
        if (requestEntity.getBody() instanceof Publisher) {
            Publisher publisher = (Publisher)requestEntity.getBody();
            result = builder.body(publisher, Object.class).exchange();
        } else {
            result = requestEntity.getBody() != null ? builder.body(BodyInserters.fromObject((Object)requestEntity.getBody())).exchange() : (this.hasBody ? ((WebClient.RequestBodySpec)builder.headers(headers -> headers.addAll((MultiValueMap)this.exchange.getRequest().getHeaders()))).body((Publisher)this.exchange.getRequest().getBody(), DataBuffer.class).exchange() : ((WebClient.RequestBodySpec)builder.headers(headers -> headers.addAll((MultiValueMap)this.exchange.getRequest().getHeaders()))).exchange());
        }
        return result.flatMap(response -> response.toEntity(ParameterizedTypeReference.forType((Type)type)));
    }

    private RequestEntity.BodyBuilder headers(RequestEntity.BodyBuilder builder) {
        Set<String> sensitive = this.sensitive;
        if (sensitive == null) {
            sensitive = DEFAULT_SENSITIVE;
        }
        this.proxy();
        for (String name : this.headers.keySet()) {
            if (sensitive.contains(name.toLowerCase())) continue;
            builder.header(name, this.headers.get((Object)name).toArray(new String[0]));
        }
        return builder;
    }

    private void proxy() {
        URI uri = this.exchange.getRequest().getURI();
        this.appendForwarded(uri);
        this.appendXForwarded(uri);
    }

    private void appendXForwarded(URI uri) {
        String host = this.headers.getFirst("x-forwarded-host");
        if (host == null) {
            return;
        }
        host = host + "," + uri.getHost();
        this.headers.set("x-forwarded-host", host);
        String proto = this.headers.getFirst("x-forwarded-proto");
        if (proto == null) {
            return;
        }
        proto = proto + "," + uri.getScheme();
        this.headers.set("x-forwarded-proto", proto);
    }

    private void appendForwarded(URI uri) {
        String forwarded = this.headers.getFirst("forwarded");
        forwarded = forwarded != null ? forwarded + "," : "";
        forwarded = forwarded + this.forwarded(uri);
        this.headers.set("forwarded", forwarded);
    }

    private String forwarded(URI uri) {
        if ("http".equals(uri.getScheme())) {
            return "host=" + uri.getHost();
        }
        return String.format("host=%s;proto=%s", uri.getHost(), uri.getScheme());
    }

    private Publisher<?> body() {
        Publisher<Object> body = this.body;
        if (body != null) {
            return body;
        }
        body = this.getRequestBody();
        this.hasBody = true;
        return body;
    }

    private Mono<Object> getRequestBody() {
        for (String key : this.bindingContext.getModel().asMap().keySet()) {
            if (!key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
            BindingResult result = (BindingResult)this.bindingContext.getModel().asMap().get(key);
            return Mono.just((Object)result.getTarget());
        }
        return null;
    }

    protected static class BodySender {
        protected BodySender() {
        }

        @ResponseBody
        public Publisher<Object> body() {
            return null;
        }
    }

    protected static class BodyGrabber {
        protected BodyGrabber() {
        }

        public Publisher<Object> body(@RequestBody Publisher<Object> body) {
            return body;
        }
    }
}

