/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public abstract class FilterBuilder {
    protected Part part;
    protected BooleanOperator booleanOperator;
    protected Class<?> entityType;

    FilterBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        this.part = part;
        this.booleanOperator = booleanOperator;
        this.entityType = entityType;
    }

    public abstract List<Filter> build(Stack<Object> var1);

    boolean isNegated() {
        return this.part.getType().name().startsWith("NOT");
    }

    protected String propertyName() {
        return this.part.getProperty().getSegment();
    }

    void setNestedAttributes(Part part, Filter filter) {
        ArrayList<Filter.NestedPathSegment> segments = new ArrayList<Filter.NestedPathSegment>();
        PropertyPath property = part.getProperty();
        if (property.hasNext()) {
            filter.setOwnerEntityType(property.getOwningType().getType());
            segments.add(new Filter.NestedPathSegment(property.getSegment(), property.getType()));
            segments.addAll(this.deepNestedProperty(property));
            filter.setPropertyName(property.getLeafProperty().getSegment());
            filter.setNestedPath(segments.toArray(new Filter.NestedPathSegment[0]));
        }
    }

    private List<Filter.NestedPathSegment> deepNestedProperty(PropertyPath path) {
        PropertyPath next;
        ArrayList<Filter.NestedPathSegment> segments = new ArrayList<Filter.NestedPathSegment>();
        if (path.hasNext() && !(next = path.next()).equals((Object)next.getLeafProperty())) {
            segments.add(new Filter.NestedPathSegment(next.getSegment(), next.getType()));
            segments.addAll(this.deepNestedProperty(next));
        }
        return segments;
    }
}

