/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.cp.api.impl.BaseWxCpServiceImpl;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxCpServiceApacheHttpClientImpl
extends BaseWxCpServiceImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.APACHE_HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!this.configStorage.isAccessTokenExpired() && !forceRefresh) {
            return this.configStorage.getAccessToken();
        }
        Object object = this.globalAccessTokenRefreshLock;
        synchronized (object) {
            String url = String.format(this.configStorage.getApiUrl("/cgi-bin/gettoken?corpid=%s&corpsecret=%s"), this.configStorage.getCorpId(), this.configStorage.getCorpSecret());
            try {
                String resultContent;
                HttpGet httpGet = new HttpGet(url);
                if (this.httpProxy != null) {
                    RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                    httpGet.setConfig(config);
                }
                try (CloseableHttpClient httpClient = this.getRequestHttpClient();
                     CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                }
                finally {
                    httpGet.releaseConnection();
                }
                WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.CP);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                this.configStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            }
            catch (IOException e) {
                throw new WxRuntimeException((Throwable)e);
            }
        }
        return this.configStorage.getAccessToken();
    }

    @Override
    public void initHttp() {
        ApacheHttpClientBuilder apacheHttpClientBuilder = this.configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(this.configStorage.getHttpProxyHost()).httpProxyPort(this.configStorage.getHttpProxyPort()).httpProxyUsername(this.configStorage.getHttpProxyUsername()).httpProxyPassword(this.configStorage.getHttpProxyPassword());
        if (this.configStorage.getHttpProxyHost() != null && this.configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(this.configStorage.getHttpProxyHost(), this.configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    public WxCpConfigStorage getWxCpConfigStorage() {
        return this.configStorage;
    }
}

