/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpSsoService;
import me.chanjar.weixin.cp.bean.WxCpSsoUserInfo;

public class WxCpSsoServiceImpl
implements WxCpSsoService {
    private final WxCpService mainService;

    @Override
    public String buildAuthorizationUrl(String state) {
        return this.buildAuthorizationUrl(this.mainService.getWxCpConfigStorage().getSsoRedirectUri(), state);
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state) {
        StringBuilder url = new StringBuilder("https://open.work.weixin.qq.com/wwopen/sso/qrConnect");
        url.append("?appid=").append(this.mainService.getWxCpConfigStorage().getCorpId());
        url.append("&agentid=").append(this.mainService.getWxCpConfigStorage().getAgentId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public WxCpSsoUserInfo getUserInfo(String code) throws WxErrorException {
        String responseText = this.mainService.get(String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/auth/getuserinfo?code=%s"), code), null);
        JsonObject jo = GsonParser.parse((String)responseText);
        return WxCpSsoUserInfo.builder().userid(GsonHelper.getString((JsonObject)jo, (String)"userid")).openid(GsonHelper.getString((JsonObject)jo, (String)"openid")).errmsg(GsonHelper.getString((JsonObject)jo, (String)"errmsg")).errcode(GsonHelper.getInteger((JsonObject)jo, (String)"errcode")).build();
    }

    public WxCpSsoServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

