/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.dp.api.plugin;

import com.cyberway.dp.api.plugin.ApiPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ApiSpiHelper {
    private static final Map<String, ApiPlugin> PLUGIN_MAP = new HashMap<String, ApiPlugin>();

    private ApiSpiHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, ApiPlugin> getAllInstance() {
        if (PLUGIN_MAP.isEmpty()) {
            ApiSpiHelper.reload();
        }
        return PLUGIN_MAP;
    }

    public static ApiPlugin getInstance(String pluginName) {
        if (PLUGIN_MAP.containsKey(pluginName)) {
            return PLUGIN_MAP.get(pluginName);
        }
        ApiSpiHelper.reload();
        if (!PLUGIN_MAP.containsKey(pluginName)) {
            throw new IllegalArgumentException("can not find plugin: " + pluginName);
        }
        return PLUGIN_MAP.get(pluginName);
    }

    private static void reload() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> aClass = classLoader.loadClass("com.cyberway.dp.api.plugin.ApiPlugin");
            ServiceLoader<ApiPlugin> serviceLoader = ServiceLoader.load(aClass);
            for (ApiPlugin apiPlugin : serviceLoader) {
                String name = apiPlugin.pluginName();
                if (PLUGIN_MAP.containsKey(name)) {
                    ApiPlugin existing = PLUGIN_MAP.get(name);
                    if (existing.priority() >= apiPlugin.priority()) continue;
                    PLUGIN_MAP.put(name, apiPlugin);
                    continue;
                }
                PLUGIN_MAP.put(name, apiPlugin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalCallerException(e.getMessage());
        }
    }
}

