/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.dp.api.plugin.basicauth;

import com.cyberway.dp.api.plugin.AbstractApiPlugin;
import com.cyberway.dp.api.plugin.BaseHttpParameter;
import com.cyberway.dp.api.plugin.ConfigItem;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthApiPlugin
extends AbstractApiPlugin {
    private static final long serialVersionUID = 1L;
    private static final String HEADER_AUTHORIZATION_KEY = "Authorization";
    private List<ConfigItem> configItems;

    @Override
    public String description() {
        return "Basic Auth\u9274\u6743";
    }

    @Override
    public String pluginName() {
        return "basic-auth";
    }

    @Override
    public List<ConfigItem> configItems() {
        if (null == this.configItems) {
            this.configItems = List.of(new ConfigItem("basic_auth_username", "\u7528\u6237\u540d", true), new ConfigItem("basic_auth_password", "\u5bc6\u7801", true));
        }
        return this.configItems;
    }

    @Override
    public void preRequest(BaseHttpParameter httpParameter, Map<String, String> configMap) {
        String username = configMap.get("basic_auth_username");
        String password = configMap.get("basic_auth_password");
        Map<String, String> headers = httpParameter.getHeaders();
        if (null == headers) {
            headers = new HashMap<String, String>();
            httpParameter.setHeaders(headers);
        }
        String base64String = Base64.encodeBase64String((byte[])String.format("%s:%s", username, password).getBytes(StandardCharsets.UTF_8));
        headers.put(HEADER_AUTHORIZATION_KEY, String.format("Basic %s", base64String));
    }
}

