/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.dp.api.plugin.mpauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.dp.api.plugin.AbstractApiPlugin;
import com.cyberway.dp.api.plugin.BaseHttpParameter;
import com.cyberway.dp.api.plugin.BaseHttpResponse;
import com.cyberway.dp.api.plugin.ConfigItem;
import com.cyberway.dp.api.plugin.mpauth.SignType;
import com.cyberway.dp.api.plugin.mpauth.SignUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpAuthApiPlugin
extends AbstractApiPlugin {
    private static final long serialVersionUID = 1L;
    private static final String HEADER_API_AUTH_APP_KEY = "auth-app-key";
    private static final String HEADER_API_AUTH_TIMESTAMP = "auth-timestamp";
    private static final String HEADER_API_AUTH_NONCE = "auth-nonce";
    private static final String HEADER_API_AUTH_SIGNATURE = "auth-signature";
    private final Logger log = LoggerFactory.getLogger(MpAuthApiPlugin.class);
    private static final String APP_KEY = "app_key";
    private static final String APP_SECRET = "app_secret";
    private static final String SIGN_TYPE = "sign_type";
    private List<ConfigItem> configItems;

    @Override
    public String description() {
        return "\u4e2d\u53f0\u63a5\u53e3\u8ba4\u8bc1";
    }

    @Override
    public String pluginName() {
        return "mp-third-part";
    }

    @Override
    public List<ConfigItem> configItems() {
        if (null == this.configItems) {
            this.configItems = List.of(new ConfigItem(APP_KEY, "\u4e2d\u53f0AppKey", true), new ConfigItem(APP_SECRET, "\u4e2d\u53f0AppSecret", true), new ConfigItem(SIGN_TYPE, "\u7b7e\u540d\u65b9\u5f0f", true));
        }
        return this.configItems;
    }

    @Override
    public void preRequest(BaseHttpParameter httpParameter, Map<String, String> configMap) {
        SignType signType = SignType.getEnum(configMap.get(SIGN_TYPE));
        String appKey = configMap.get(APP_KEY);
        String appSecret = configMap.get(APP_SECRET);
        String nonce = UUID.randomUUID().toString();
        String timestamp = String.valueOf(System.currentTimeMillis());
        String signContent = this.buildSignContent(appKey, nonce, timestamp);
        String sign = SignUtil.sign(signContent, signType, appSecret);
        Map<String, String> headers = httpParameter.getHeaders();
        if (null == headers) {
            headers = new HashMap<String, String>();
            httpParameter.setHeaders(headers);
        }
        headers.put(HEADER_API_AUTH_APP_KEY, appKey);
        headers.put(HEADER_API_AUTH_TIMESTAMP, timestamp);
        headers.put(HEADER_API_AUTH_NONCE, nonce);
        headers.put(HEADER_API_AUTH_SIGNATURE, sign);
    }

    @Override
    public boolean hasMore(BaseHttpParameter httpParameter, BaseHttpResponse httpResponse) {
        boolean hasMore = false;
        try {
            int totalPage;
            JSONObject dataObject;
            int current;
            JSONObject jsonObject;
            String content = httpResponse.getContent();
            if (StringUtils.isNotBlank((CharSequence)content) && (jsonObject = JSON.parseObject((String)content)).containsKey((Object)"data") && jsonObject.containsKey((Object)"success") && Boolean.TRUE.equals(jsonObject.getBoolean("success")) && (current = (dataObject = jsonObject.getJSONObject("data")).getIntValue("current")) < (totalPage = dataObject.getIntValue("totalPage"))) {
                this.modifyPageParam(httpParameter);
                hasMore = true;
            }
        }
        catch (Exception e) {
            this.log.error("hasMore error", (Throwable)e);
        }
        return hasMore;
    }

    private void modifyPageParam(BaseHttpParameter httpParameter) {
        String body = httpParameter.getBody();
        JSONObject bodyJson = JSON.parseObject((String)body);
        if (!bodyJson.containsKey((Object)"current")) {
            throw new IllegalArgumentException("current\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        bodyJson.put("current", (Object)(bodyJson.getIntValue("current") + 1));
        httpParameter.setBody(bodyJson.toJSONString());
    }

    private String buildSignContent(String appKey, String nonce, String timestamp) {
        String signBaseString = "appKey=" + appKey + "&nonce=" + nonce + "&timestamp=" + timestamp;
        this.log.debug("signBaseString:{}", (Object)signBaseString);
        return signBaseString;
    }
}

