/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.dp.api.plugin.mpauth;

import com.cyberway.dp.api.plugin.mpauth.SignType;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtil.class);

    private SignUtil() {
        throw new UnsupportedOperationException();
    }

    public static String sign(String signBaseString, SignType signType, String appSecret) {
        switch (signType) {
            case SHA1: {
                return SignUtil.sign(signBaseString, SignType.SHA1.getName());
            }
            case SHA256: {
                return SignUtil.sign(signBaseString, SignType.SHA256.getName());
            }
            case HMAC_MD5: {
                return SignUtil.hmacSign(signBaseString, appSecret, SignType.HMAC_MD5.getName());
            }
            case HMAC_SHA1: {
                return SignUtil.hmacSign(signBaseString, appSecret, SignType.HMAC_SHA1.getName());
            }
            case HMAC_SHA256: {
                return SignUtil.hmacSign(signBaseString, appSecret, SignType.HMAC_SHA256.getName());
            }
        }
        return SignUtil.sign(signBaseString, SignType.MD5.getName());
    }

    private static String hmacSign(String content, String apiSecret, String signType) {
        String sign = null;
        try {
            Mac hmac = Mac.getInstance(signType);
            SecretKeySpec secretKey = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), signType);
            hmac.init(secretKey);
            byte[] bytes = hmac.doFinal(content.getBytes(StandardCharsets.UTF_8));
            sign = SignUtil.encodeBytes(bytes);
        }
        catch (Exception e) {
            LOGGER.error("{} signature fail.", (Object)signType);
        }
        return sign;
    }

    private static String sign(String content, String signType) {
        String sign = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance(signType);
            byte[] bytes = md5.digest(content.getBytes(StandardCharsets.UTF_8));
            sign = SignUtil.encodeBytes(bytes);
        }
        catch (Exception e) {
            LOGGER.error("{} signature fail.", (Object)signType);
        }
        return sign;
    }

    private static String encodeBytes(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes);
    }
}

