/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.dp.api.plugin.page;

import com.alibaba.fastjson.JSONObject;
import com.cyberway.dp.api.plugin.BaseHttpParameter;
import com.cyberway.dp.api.plugin.BaseHttpResponse;
import com.cyberway.dp.api.plugin.page.PageHandler;
import com.cyberway.dp.api.plugin.page.SimplePageConfig;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePageHandler
implements PageHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SimplePageHandler.class);
    private final SimplePageConfig config;
    private transient JsonPath requestPageParamJsonPath;
    private transient JsonPath responseTotalPageParamJsonPath;

    public SimplePageHandler(JSONObject pageConfigMapJson) {
        this.config = (SimplePageConfig)pageConfigMapJson.toJavaObject(SimplePageConfig.class);
    }

    @Override
    public void validateAndInit() {
        if (null == this.config.getFirstPageIndex()) {
            throw new IllegalArgumentException("firstPageIndex\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.config.getRequestPageParamJsonPath() || "".equals(this.config.getRequestPageParamJsonPath())) {
            throw new IllegalArgumentException("requestPageParamJsonPath\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.config.getResponseTotalPageParamJsonPath() || "".equals(this.config.getResponseTotalPageParamJsonPath())) {
            throw new IllegalArgumentException("responseTotalPageParamJsonPath\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.requestPageParamJsonPath = JsonPath.compile((String)this.config.getRequestPageParamJsonPath(), (Predicate[])new Predicate[0]);
        this.responseTotalPageParamJsonPath = JsonPath.compile((String)this.config.getResponseTotalPageParamJsonPath(), (Predicate[])new Predicate[0]);
    }

    @Override
    public boolean hasMore(BaseHttpParameter httpParameter, BaseHttpResponse httpResponse) {
        if (null == this.requestPageParamJsonPath) {
            this.validateAndInit();
        }
        try {
            DocumentContext responseCtx = JsonPath.parse((String)httpResponse.getContent());
            Object totalPageObj = responseCtx.read(this.responseTotalPageParamJsonPath);
            Integer totalPage = this.tryCover2Integer(totalPageObj);
            DocumentContext requestCtx = JsonPath.parse((String)httpParameter.getBody());
            Object currentPageObj = requestCtx.read(this.requestPageParamJsonPath);
            Integer currentPage = this.tryCover2Integer(currentPageObj);
            if (currentPage - this.config.getFirstPageIndex() + 1 < totalPage) {
                requestCtx.set(this.requestPageParamJsonPath, (Object)(currentPage + 1));
                httpParameter.setBody(requestCtx.jsonString());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u5904\u7406\u5931\u8d25\uff0c\u54cd\u5e94\u5185\u5bb9\u662f:{}", (Object)httpResponse.getContent());
            throw new IllegalCallerException(e);
        }
    }

    private Integer tryCover2Integer(Object integerVal) {
        if (integerVal instanceof Integer) {
            return (Integer)integerVal;
        }
        if (integerVal instanceof String) {
            return Integer.parseInt((String)integerVal);
        }
        if (integerVal instanceof Long) {
            return ((Long)integerVal).intValue();
        }
        logger.error("\u4e0d\u5408\u6cd5\u7684\u6574\u5f62\u6570\u5b57\u5185\u5bb9\uff1a{}", integerVal);
        throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u6574\u5f62\u6570\u5b57\u5185\u5bb9\uff1a" + integerVal);
    }
}

